/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.watch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.grails.io.watch.AbstractDirectoryWatcher;
import org.grails.io.watch.PollingDirectoryWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryWatcher.class);
    private final AbstractDirectoryWatcher directoryWatcherDelegate;
    public static final String SVN_DIR_NAME = ".svn";

    public DirectoryWatcher() {
        AbstractDirectoryWatcher directoryWatcherDelegate;
        this.setDaemon(true);
        try {
            directoryWatcherDelegate = (AbstractDirectoryWatcher)Class.forName("org.grails.io.watch.WatchServiceDirectoryWatcher").newInstance();
        }
        catch (Throwable e) {
            LOG.info("Exception while trying to load WatchServiceDirectoryWatcher (this is probably Java 6 and WatchService isn't available). Falling back to PollingDirectoryWatcher.", e);
            directoryWatcherDelegate = new PollingDirectoryWatcher();
        }
        this.directoryWatcherDelegate = directoryWatcherDelegate;
    }

    public void setActive(boolean active) {
        this.directoryWatcherDelegate.setActive(active);
    }

    public void setSleepTime(long sleepTime) {
        this.directoryWatcherDelegate.setSleepTime(sleepTime);
    }

    public void addListener(FileChangeListener listener) {
        this.directoryWatcherDelegate.addListener(listener);
    }

    public void addWatchFile(File fileToWatch) {
        this.directoryWatcherDelegate.addWatchFile(fileToWatch);
    }

    public void addWatchDirectory(File dir, List<String> fileExtensions) {
        ArrayList<String> fileExtensionsWithoutDot = new ArrayList<String>(fileExtensions.size());
        for (String fileExtension : fileExtensions) {
            fileExtensionsWithoutDot.add(this.removeStartingDotIfPresent(fileExtension));
        }
        this.directoryWatcherDelegate.addWatchDirectory(dir, fileExtensions);
    }

    public void addWatchDirectory(File dir) {
        this.addWatchDirectory(dir, "*");
    }

    public void addWatchDirectory(File dir, String extension) {
        extension = this.removeStartingDotIfPresent(extension);
        ArrayList<String> fileExtensions = new ArrayList<String>();
        if (extension != null && extension.length() > 0) {
            fileExtensions.add("*");
        } else {
            fileExtensions.add(extension);
        }
        this.addWatchDirectory(dir, fileExtensions);
    }

    @Override
    public void run() {
        this.directoryWatcherDelegate.run();
    }

    private String removeStartingDotIfPresent(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        return extension;
    }

    public static interface FileChangeListener {
        public void onChange(File var1);

        public void onNew(File var1);
    }
}

