/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.util.AntBuilder;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.codehaus.gant.GantBinding;
import org.codehaus.groovy.grails.cli.api.BaseSettingsApi;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleAntBuilder;
import org.codehaus.groovy.grails.cli.parsing.CommandLine;
import org.codehaus.groovy.grails.cli.support.GrailsBuildEventListener;
import org.codehaus.groovy.grails.cli.support.PluginPathDiscoverySupport;

public class ScriptBindingInitializer {
    private static final Pattern pluginDescriptorPattern = Pattern.compile("^(\\S+)GrailsPlugin.groovy$");
    public static final String GRAILS_SCRIPT = "grailsScript";
    public static final String GRAILS_CONSOLE = "grailsConsole";
    public static final String GRAILS_SETTINGS = "grailsSettings";
    public static final String BASEDIR = "basedir";
    public static final String SCAFFOLD_DIR = "scaffoldDir";
    public static final String BASE_FILE = "baseFile";
    public static final String BASE_NAME = "baseName";
    public static final String GRAILS_HOME = "grailsHome";
    public static final String GRAILS_VERSION = "grailsVersion";
    public static final String USER_HOME = "userHome";
    public static final String GRAILS_ENV = "grailsEnv";
    public static final String ARGS_MAP = "argsMap";
    private BuildSettings settings;
    private PluginPathDiscoverySupport pluginPathSupport;
    private CommandLine commandLine;
    private URLClassLoader classLoader;
    private boolean interactive;

    public ScriptBindingInitializer(CommandLine commandLine, URLClassLoader classLoader, BuildSettings settings, PluginPathDiscoverySupport pluginPathSupport, boolean interactive) {
        this.commandLine = commandLine;
        this.settings = settings;
        this.pluginPathSupport = pluginPathSupport;
        this.classLoader = classLoader;
        this.interactive = interactive;
    }

    public GantBinding initBinding(GantBinding binding, String scriptName) {
        BuildSettings buildSettings = this.settings;
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>(this.commandLine.getUndeclaredOptions());
        argsMap.put("params", this.commandLine.getRemainingArgs());
        binding.setVariable(ARGS_MAP, argsMap);
        binding.setVariable("args", (Object)this.commandLine.getRemainingArgsLineSeparated());
        URLClassLoader classLoader = this.classLoader;
        GrailsConsole grailsConsole = GrailsConsole.getInstance();
        File basedir = buildSettings.getBaseDir();
        BaseSettingsApi cla = ScriptBindingInitializer.initBinding((Binding)binding, buildSettings, classLoader, grailsConsole, this.interactive);
        binding.setVariable("Ant", binding.getVariable("ant"));
        this.setUIListener(binding);
        try {
            ArrayList<File> descriptors = new ArrayList<File>();
            File desc = this.pluginPathSupport.getPluginDescriptor(basedir);
            if (desc != null) {
                descriptors.add(desc);
            }
            for (File dir : this.pluginPathSupport.listKnownPluginDirs()) {
                File pluginDescriptor = this.pluginPathSupport.getPluginDescriptor(dir);
                if (pluginDescriptor != null) {
                    descriptors.add(pluginDescriptor);
                    continue;
                }
                grailsConsole.log("Cannot find plugin descriptor for path '" + dir.getPath() + "'.");
            }
            for (File file : descriptors) {
                Matcher matcher = pluginDescriptorPattern.matcher(file.getName());
                matcher.find();
                String pluginName = GrailsNameUtils.getPropertyName(matcher.group(1));
                binding.setVariable(pluginName + "PluginDir", (Object)file.getParentFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return binding;
    }

    public static BaseSettingsApi initBinding(Binding binding, BuildSettings buildSettings, URLClassLoader classLoader, GrailsConsole grailsConsole, boolean interactive) {
        Closure c = buildSettings.getGrailsScriptClosure();
        c.setDelegate((Object)binding);
        binding.setVariable(GRAILS_SCRIPT, (Object)c);
        binding.setVariable(GRAILS_CONSOLE, (Object)grailsConsole);
        binding.setVariable(GRAILS_SETTINGS, (Object)buildSettings);
        File basedir = buildSettings.getBaseDir();
        String baseDirPath = basedir.getPath();
        binding.setVariable(BASEDIR, (Object)baseDirPath);
        binding.setVariable(SCAFFOLD_DIR, (Object)(baseDirPath + "/web-app/WEB-INF/templates/scaffolding"));
        binding.setVariable(BASE_FILE, (Object)basedir);
        binding.setVariable(BASE_NAME, (Object)basedir.getName());
        binding.setVariable(GRAILS_HOME, buildSettings.getGrailsHome() != null ? buildSettings.getGrailsHome().getPath() : null);
        binding.setVariable(GRAILS_VERSION, (Object)buildSettings.getGrailsVersion());
        binding.setVariable(USER_HOME, (Object)buildSettings.getUserHome());
        binding.setVariable(GRAILS_ENV, (Object)buildSettings.getGrailsEnv());
        binding.setVariable("defaultEnv", (Object)buildSettings.getDefaultEnv());
        binding.setVariable("buildConfig", (Object)buildSettings.getConfig());
        binding.setVariable("rootLoader", (Object)buildSettings.getRootLoader());
        binding.setVariable("configFile", (Object)buildSettings.getConfigFile());
        String grailsWork = buildSettings.getGrailsWorkDir().getPath();
        binding.setVariable("grailsWorkDir", (Object)grailsWork);
        binding.setVariable("projectWorkDir", (Object)buildSettings.getProjectWorkDir().getPath());
        binding.setVariable("projectTargetDir", (Object)buildSettings.getProjectTargetDir());
        binding.setVariable("classesDir", (Object)buildSettings.getClassesDir());
        binding.setVariable("pluginClassesDir", (Object)buildSettings.getPluginClassesDir());
        binding.setVariable("grailsTmp", (Object)(grailsWork + "/tmp"));
        binding.setVariable("classesDirPath", (Object)buildSettings.getClassesDir().getPath());
        binding.setVariable("pluginClassesDirPath", (Object)buildSettings.getPluginClassesDir().getPath());
        binding.setVariable("testDirPath", (Object)buildSettings.getTestClassesDir().getPath());
        String resourcesDir = buildSettings.getResourcesDir().getPath();
        binding.setVariable("resourcesDirPath", (Object)resourcesDir);
        binding.setVariable("webXmlFile", (Object)buildSettings.getWebXmlLocation());
        binding.setVariable("pluginsDirPath", (Object)buildSettings.getProjectPluginsDir().getPath());
        binding.setVariable("globalPluginsDirPath", (Object)buildSettings.getGlobalPluginsDir().getPath());
        GroovyClassLoader eventsClassLoader = new GroovyClassLoader((ClassLoader)classLoader);
        GrailsBuildEventListener buildEventListener = new GrailsBuildEventListener(eventsClassLoader, binding, buildSettings);
        binding.setVariable("eventsClassLoader", (Object)eventsClassLoader);
        binding.setVariable("eventListener", (Object)buildEventListener);
        if (binding instanceof GantBinding) {
            ((GantBinding)binding).addBuildListener((BuildListener)buildEventListener);
        }
        BaseSettingsApi cla = new BaseSettingsApi(buildSettings, buildEventListener, interactive);
        cla.makeApiAvailableToScripts(binding, cla);
        cla.makeApiAvailableToScripts(binding, cla.getPluginSettings());
        return cla;
    }

    private void setUIListener(GantBinding binding) {
        AntBuilder ant = (AntBuilder)binding.getVariable("ant");
        Project project = ant.getProject();
        project.getBuildListeners().clear();
        GrailsConsoleAntBuilder.addGrailsConsoleBuildListener(project);
    }
}

