/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.io.support;

import groovy.util.XmlSlurper;
import groovy.xml.FactorySupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class IOUtils {
    private static Map algorithms = new HashMap();
    private static final char[] CHARS;
    public static final int BUFFER_SIZE = 4096;
    private static SAXParserFactory saxParserFactory;

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(CHARS[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(CHARS[ch]);
        }
        return out.toString();
    }

    public static String computeChecksum(File f, String algorithm) throws IOException {
        return IOUtils.byteArrayToHexString(IOUtils.compute(f, algorithm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compute(File f, String algorithm) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            MessageDigest md = IOUtils.getMessageDigest(algorithm);
            md.reset();
            byte[] buf = new byte[4096];
            int len = 0;
            while ((len = ((InputStream)is).read(buf)) != -1) {
                md.update(buf, 0, len);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        String mdAlgorithm = (String)algorithms.get(algorithm);
        if (mdAlgorithm == null) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
        try {
            return MessageDigest.getInstance(mdAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type1 = array1.getClass().getComponentType();
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName());
            }
            throw ase;
        }
        return joinedArray;
    }

    public static int copy(File in, File out) throws IOException {
        assert (in != null) : "No input File specified";
        assert (out != null) : "No output File specified";
        return IOUtils.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        assert (in != null) : "No input byte array specified";
        assert (out != null) : "No output File specified";
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        IOUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        assert (in != null) : "No input File specified";
        return IOUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        assert (in != null) : "No input stream specified";
        assert (out != null) : "No output stream specified";
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        assert (in != null) : "No input byte array specified";
        assert (out != null) : "No output stream specified";
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        assert (in != null) : "No input Reader specified";
        assert (out != null) : "No output Writer specified";
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        assert (in != null) : "No input String specified";
        assert (out != null) : "No output Writer specified";
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        IOUtils.copy(in, (Writer)out);
        return out.toString();
    }

    public static XmlSlurper createXmlSlurper() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = IOUtils.createParserFactory();
        return new XmlSlurper(factory.newSAXParser());
    }

    private static SAXParserFactory createParserFactory() throws ParserConfigurationException {
        if (saxParserFactory == null) {
            saxParserFactory = FactorySupport.createSaxParserFactory();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(false);
            saxParserFactory.setXIncludeAware(false);
            try {
                saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saxParserFactory;
    }

    static {
        algorithms.put("md5", "MD5");
        algorithms.put("sha1", "SHA-1");
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        saxParserFactory = null;
    }
}

