/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.api;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import grails.util.Metadata;
import grails.util.PluginBuildSettings;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.util.ConfigSlurper;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.groovy.grails.cli.ScriptExitException;
import org.codehaus.groovy.grails.cli.support.GrailsBuildEventListener;
import org.codehaus.groovy.grails.io.support.ClassPathResource;
import org.codehaus.groovy.grails.io.support.FileSystemResource;
import org.codehaus.groovy.grails.io.support.IOUtils;
import org.codehaus.groovy.grails.io.support.PathMatchingResourcePatternResolver;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.runtime.MethodClosure;
import org.xml.sax.SAXException;

public class BaseSettingsApi {
    private static final Resource[] NO_RESOURCES = new Resource[0];
    protected BuildSettings buildSettings;
    protected Properties buildProps;
    protected PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    protected File grailsHome;
    protected Metadata metadata;
    protected File metadataFile;
    protected boolean enableProfile;
    protected boolean isInteractive;
    protected String pluginsHome;
    protected PluginBuildSettings pluginSettings;
    protected String grailsAppName;
    protected Object appClassName;
    protected ConfigSlurper configSlurper;
    protected GrailsBuildEventListener buildEventListener;

    public BaseSettingsApi(BuildSettings buildSettings, boolean interactive) {
        this(buildSettings, null, interactive);
    }

    public BaseSettingsApi(BuildSettings settings, GrailsBuildEventListener buildEventListener, boolean interactive) {
        this.buildSettings = settings;
        this.buildProps = this.buildSettings.getConfig().toProperties();
        this.grailsHome = this.buildSettings.getGrailsHome();
        this.metadataFile = new File(this.buildSettings.getBaseDir(), "application.properties");
        this.metadata = this.metadataFile.exists() ? Metadata.getInstance(this.metadataFile) : Metadata.getCurrent();
        this.metadata.setServletVersion(this.buildSettings.getServletVersion());
        this.metadataFile = this.metadata.getMetadataFile();
        this.enableProfile = Boolean.valueOf(this.getPropertyValue("grails.script.profile", false).toString());
        this.pluginsHome = this.buildSettings.getProjectPluginsDir().getPath();
        this.pluginSettings = GrailsPluginUtils.getPluginBuildSettings(settings);
        this.grailsAppName = this.metadata.getApplicationName();
        this.isInteractive = interactive;
        if (this.grailsAppName == null) {
            this.grailsAppName = this.buildSettings.getBaseDir().getName();
        }
        this.appClassName = this.grailsAppName.indexOf(47) > -1 ? this.grailsAppName.substring(this.grailsAppName.lastIndexOf(47), this.grailsAppName.length()) : GrailsNameUtils.getClassNameRepresentation(this.grailsAppName);
        this.configSlurper = this.buildSettings.createConfigSlurper();
        this.configSlurper.setEnvironment(this.buildSettings.getGrailsEnv());
        this.buildEventListener = buildEventListener;
    }

    public GrailsBuildEventListener getBuildEventListener() {
        return this.buildEventListener;
    }

    public ConfigSlurper getConfigSlurper() {
        return this.configSlurper;
    }

    public Object getAppClassName() {
        return this.appClassName;
    }

    public int getServerPort() {
        int serverPort = Integer.valueOf(this.getPropertyValue("server.port", 8080).toString());
        serverPort = Integer.valueOf(this.getPropertyValue("grails.server.port.http", serverPort).toString());
        return serverPort;
    }

    public int getServerPortHttps() {
        int serverPortHttps = Integer.valueOf(this.getPropertyValue("server.port.https", 8443).toString());
        serverPortHttps = Integer.valueOf(this.getPropertyValue("grails.server.port.https", serverPortHttps).toString());
        return serverPortHttps;
    }

    public String getServerHost() {
        return (String)this.getPropertyValue("grails.server.host", null);
    }

    public String getGrailsAppName() {
        return this.grailsAppName;
    }

    public String getGrailsAppVersion() {
        return this.metadata.getApplicationVersion();
    }

    public String getAppGrailsVersion() {
        return this.metadata.getGrailsVersion();
    }

    public String getServletVersion() {
        return this.buildSettings.getServletVersion();
    }

    public String getPluginsHome() {
        return this.pluginsHome;
    }

    public PluginBuildSettings getPluginBuildSettings() {
        return this.pluginSettings;
    }

    public PluginBuildSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public BuildSettings getBuildSettings() {
        return this.buildSettings;
    }

    public Properties getBuildProps() {
        return this.buildProps;
    }

    public PathMatchingResourcePatternResolver getResolver() {
        return this.resolver;
    }

    public File getGrailsHome() {
        return this.grailsHome;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public boolean isEnableProfile() {
        return this.enableProfile;
    }

    public boolean getIsInteractive() {
        return this.isInteractive;
    }

    public Resource[] resolveResources(String pattern) {
        try {
            return this.resolver.getResources(pattern);
        }
        catch (Exception e) {
            return NO_RESOURCES;
        }
    }

    public Resource grailsResource(String path) {
        if (this.grailsHome != null) {
            FileSystemResource resource = new FileSystemResource(this.grailsHome + "/" + path);
            if (!resource.exists()) {
                resource = new FileSystemResource(this.grailsHome + "/grails-resources/" + path);
            }
            return resource;
        }
        return new ClassPathResource(path);
    }

    public void copyGrailsResource(Object targetFile, Resource resource) throws FileNotFoundException, IOException {
        this.copyGrailsResource(targetFile, resource, true);
    }

    public void copyGrailsResource(Object targetFile, Resource resource, boolean overwrite) throws FileNotFoundException, IOException {
        File file = new File(targetFile.toString());
        if (overwrite || !file.exists()) {
            IOUtils.copy(resource.getInputStream(), (OutputStream)new FileOutputStream(file));
        }
    }

    public void copyGrailsResources(Object destDir, Object pattern) throws FileNotFoundException, IOException {
        this.copyGrailsResources(destDir, pattern, true);
    }

    public void copyGrailsResources(Object destDir, Object pattern, boolean overwrite) throws FileNotFoundException, IOException {
        Resource[] resources;
        new File(destDir.toString()).mkdirs();
        for (Resource resource : resources = this.resolveResources("classpath:" + pattern)) {
            if (!resource.isReadable()) continue;
            this.copyGrailsResource(destDir + "/" + resource.getFilename(), resource, overwrite);
        }
    }

    public Object getPropertyValue(String propName, Object defaultValue) {
        Object value = System.getProperty(propName);
        if (value != null) {
            return value;
        }
        value = this.buildProps.get(propName);
        return value != null ? value : defaultValue;
    }

    public void updateMetadata(Metadata metadata, Map entries) {
        for (Object key : entries.keySet()) {
            Object value = entries.get(key);
            if (value == null) continue;
            metadata.put(key, value.toString());
        }
        metadata.persist();
    }

    public void updateMetadata(Map entries) {
        this.updateMetadata(Metadata.getCurrent(), entries);
    }

    public GPathResult readPluginXmlMetadata(String pluginName) throws Exception {
        Resource pluginResource = this.pluginSettings.getPluginDirForName(pluginName);
        if (pluginResource != null) {
            File pluginDir = pluginResource.getFile();
            return this.createXmlSlurper().parse(new File(pluginDir, "plugin.xml"));
        }
        return null;
    }

    public List<GPathResult> readAllPluginXmlMetadata() throws Exception {
        Resource[] allFiles = this.pluginSettings.getPluginXmlMetadata();
        ArrayList<GPathResult> results = new ArrayList<GPathResult>();
        for (Resource resource : allFiles) {
            if (!resource.exists()) continue;
            results.add(this.createXmlSlurper().parse(resource.getFile()));
        }
        return results;
    }

    public XmlSlurper createXmlSlurper() throws ParserConfigurationException, SAXException {
        return IOUtils.createXmlSlurper();
    }

    public void profile(String name, Closure<?> callable) {
        if (this.enableProfile) {
            long now = System.currentTimeMillis();
            GrailsConsole console = GrailsConsole.getInstance();
            console.addStatus("Profiling [" + name + "] start");
            callable.call();
            long then = System.currentTimeMillis() - now;
            console.addStatus("Profiling [" + name + "] finish. Took " + then + " ms");
        } else {
            callable.call();
        }
    }

    public String makeRelative(String path) {
        String absolutePath;
        if (this.buildSettings != null && path != null && path.startsWith(absolutePath = this.buildSettings.getBaseDir().getAbsolutePath())) {
            return path.substring(absolutePath.length() + 1);
        }
        return path;
    }

    public String makeRelative(File file) {
        return this.makeRelative(file.getAbsolutePath());
    }

    public void exit(int code) {
        if (this.buildEventListener != null) {
            this.buildEventListener.triggerEvent("Exiting", code);
        }
        if (System.getProperty("grails.cli.testing") != null || System.getProperty("grails.disable.exit") != null) {
            throw new ScriptExitException(code);
        }
        GrailsConsole.getInstance().cleanlyExit(code);
    }

    public boolean confirmInput(String message, String code) {
        if (code == null) {
            code = "confirm.message";
        }
        GrailsConsole grailsConsole = GrailsConsole.getInstance();
        if (!this.isInteractive) {
            grailsConsole.error("Cannot ask for input when --non-interactive flag is passed. Please switch back to interactive mode.");
            this.exit(1);
        }
        return "y".equalsIgnoreCase(grailsConsole.userInput(message, new String[]{"y", "n"}));
    }

    public boolean confirmInput(String message) {
        return this.confirmInput(message, "confirm.message");
    }

    public void logError(String message, Throwable t) {
        GrailsConsole.getInstance().error(message, t);
    }

    public void logErrorAndExit(String message, Throwable t) {
        this.logError(message, t);
        this.exit(1);
    }

    public void makeApiAvailableToScripts(Binding binding, Object cla) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = cla.getClass().getDeclaredMethods()) {
            String name = method.getName();
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            binding.setVariable(name, (Object)new MethodClosure(cla, name));
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(cla.getClass()).getPropertyDescriptors()) {
                Method readMethod = pd.getReadMethod();
                if (readMethod == null || !this.isDeclared(cla, readMethod)) continue;
                binding.setVariable(pd.getName(), this.invokeMethod(readMethod, cla));
            }
        }
        catch (IntrospectionException e1) {
            // empty catch block
        }
    }

    private Object invokeMethod(Method readMethod, Object cla) {
        try {
            return readMethod.invoke(cla, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    protected boolean isDeclared(Object cla, Method readMethod) {
        try {
            return cla.getClass().getDeclaredMethod(readMethod.getName(), readMethod.getParameterTypes()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

