/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.io.support;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public class AntPathMatcher {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?\\}");
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator == null ? DEFAULT_PATH_SEPARATOR : pathSeparator;
    }

    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    public boolean match(String pattern, String path) {
        return this.doMatch(pattern, path, true, null);
    }

    public boolean matchStart(String pattern, String path) {
        return this.doMatch(pattern, path, false, null);
    }

    protected boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = this.tokenize(pattern);
        String[] pathDirs = this.tokenize(path);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart], uriTemplateVariables)) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) ? path.endsWith(this.pathSeparator) : !path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd], uriTemplateVariables)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!this.matchStrings(subPat, subStr, uriTemplateVariables)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private String[] tokenize(String pattern) {
        List list = StringGroovyMethods.tokenize((String)pattern, (String)this.pathSeparator);
        return list.toArray(new String[list.size()]);
    }

    private boolean matchStrings(String pattern, String str, Map<String, String> uriTemplateVariables) {
        AntPathStringMatcher matcher = new AntPathStringMatcher(pattern, str, uriTemplateVariables);
        return matcher.matchStrings();
    }

    public String extractPathWithinPattern(String pattern, String path) {
        int i;
        String[] patternParts = this.tokenize(pattern);
        String[] pathParts = this.tokenize(path);
        StringBuilder builder = new StringBuilder();
        int puts = 0;
        for (i = 0; i < patternParts.length; ++i) {
            String patternPart = patternParts[i];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1 || pathParts.length < i + 1) continue;
            if (puts > 0 || i == 0 && !pattern.startsWith(this.pathSeparator)) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
            ++puts;
        }
        for (i = patternParts.length; i < pathParts.length; ++i) {
            if (puts > 0 || i > 0) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
        }
        return builder.toString();
    }

    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        this.doMatch(pattern, path, true, variables);
        return variables;
    }

    public String combine(String pattern1, String pattern2) {
        String extension2;
        String fileName2;
        if (!this.hasText(pattern1) && !this.hasText(pattern2)) {
            return "";
        }
        if (!this.hasText(pattern1)) {
            return pattern2;
        }
        if (!this.hasText(pattern2)) {
            return pattern1;
        }
        if (!pattern1.contains("{") && this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith("/*")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1.substring(0, pattern1.length() - 1) + pattern2.substring(1);
            }
            return pattern1.substring(0, pattern1.length() - 1) + pattern2;
        }
        if (pattern1.endsWith("/**")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1 + pattern2;
            }
            return pattern1 + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        int dotPos1 = pattern1.indexOf(46);
        if (dotPos1 == -1) {
            if (pattern1.endsWith(DEFAULT_PATH_SEPARATOR) || pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1 + pattern2;
            }
            return pattern1 + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        String fileName1 = pattern1.substring(0, dotPos1);
        String extension1 = pattern1.substring(dotPos1);
        int dotPos2 = pattern2.indexOf(46);
        if (dotPos2 != -1) {
            fileName2 = pattern2.substring(0, dotPos2);
            extension2 = pattern2.substring(dotPos2);
        } else {
            fileName2 = pattern2;
            extension2 = "";
        }
        String fileName = fileName1.endsWith("*") ? fileName2 : fileName1;
        String extension = extension1.startsWith("*") ? extension2 : extension1;
        return fileName + extension;
    }

    private boolean hasText(String txt) {
        return txt != null && txt.length() > 0;
    }

    public Comparator<String> getPatternComparator(String path) {
        return new AntPatternComparator(path);
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    static class AntPathStringMatcher {
        private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
        private final String DEFAULT_VARIABLE_PATTERN = "(.*)";
        private final Pattern pattern;
        private String str;
        private final List<String> variableNames = new LinkedList<String>();
        private final Map<String, String> uriTemplateVariables;

        AntPathStringMatcher(String pattern, String str, Map<String, String> uriTemplateVariables) {
            this.str = str;
            this.uriTemplateVariables = uriTemplateVariables;
            this.pattern = this.createPattern(pattern);
        }

        private Pattern createPattern(String p) {
            StringBuilder patternBuilder = new StringBuilder();
            Matcher m = GLOB_PATTERN.matcher(p);
            int end = 0;
            while (m.find()) {
                patternBuilder.append(this.quote(p, end, m.start()));
                String match = m.group();
                if ("?".equals(match)) {
                    patternBuilder.append('.');
                } else if ("*".equals(match)) {
                    patternBuilder.append(".*");
                } else if (match.startsWith("{") && match.endsWith("}")) {
                    int colonIdx = match.indexOf(58);
                    if (colonIdx == -1) {
                        patternBuilder.append("(.*)");
                        this.variableNames.add(m.group(1));
                    } else {
                        String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                        patternBuilder.append('(');
                        patternBuilder.append(variablePattern);
                        patternBuilder.append(')');
                        String variableName = match.substring(1, colonIdx);
                        this.variableNames.add(variableName);
                    }
                }
                end = m.end();
            }
            patternBuilder.append(this.quote(p, end, p.length()));
            return Pattern.compile(patternBuilder.toString());
        }

        private String quote(String s, int start, int end) {
            if (start == end) {
                return "";
            }
            return Pattern.quote(s.substring(start, end));
        }

        public boolean matchStrings() {
            Matcher matcher = this.pattern.matcher(this.str);
            if (!matcher.matches()) {
                return false;
            }
            if (this.uriTemplateVariables != null) {
                int count = matcher.groupCount();
                for (int i = 1; i <= count; ++i) {
                    String name = this.variableNames.get(i - 1);
                    String value = matcher.group(i);
                    this.uriTemplateVariables.put(name, value);
                }
            }
            return true;
        }
    }

    private static class AntPatternComparator
    implements Comparator<String> {
        private final String path;

        private AntPatternComparator(String path) {
            this.path = path;
        }

        @Override
        public int compare(String pattern1, String pattern2) {
            int pattern2Length;
            int bracketCount2;
            int totalCount2;
            if (pattern1 == null && pattern2 == null) {
                return 0;
            }
            if (pattern1 == null) {
                return 1;
            }
            if (pattern2 == null) {
                return -1;
            }
            boolean pattern1EqualsPath = pattern1.equals(this.path);
            boolean pattern2EqualsPath = pattern2.equals(this.path);
            if (pattern1EqualsPath && pattern2EqualsPath) {
                return 0;
            }
            if (pattern1EqualsPath) {
                return -1;
            }
            if (pattern2EqualsPath) {
                return 1;
            }
            int wildCardCount1 = this.getWildCardCount(pattern1);
            int wildCardCount2 = this.getWildCardCount(pattern2);
            int bracketCount1 = AntPathMatcher.countOccurrencesOf(pattern1, "{");
            int totalCount1 = wildCardCount1 + bracketCount1;
            if (totalCount1 != (totalCount2 = wildCardCount2 + (bracketCount2 = AntPathMatcher.countOccurrencesOf(pattern2, "{")))) {
                return totalCount1 - totalCount2;
            }
            int pattern1Length = this.getPatternLength(pattern1);
            if (pattern1Length != (pattern2Length = this.getPatternLength(pattern2))) {
                return pattern2Length - pattern1Length;
            }
            if (wildCardCount1 < wildCardCount2) {
                return -1;
            }
            if (wildCardCount2 < wildCardCount1) {
                return 1;
            }
            if (bracketCount1 < bracketCount2) {
                return -1;
            }
            if (bracketCount2 < bracketCount1) {
                return 1;
            }
            return 0;
        }

        private int getWildCardCount(String pattern) {
            if (pattern.endsWith(".*")) {
                pattern = pattern.substring(0, pattern.length() - 2);
            }
            return AntPathMatcher.countOccurrencesOf(pattern, "*");
        }

        private int getPatternLength(String pattern) {
            Matcher m = VARIABLE_PATTERN.matcher(pattern);
            return m.replaceAll("#").length();
        }
    }
}

