/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.logging;

import grails.build.logging.GrailsConsole;
import groovy.util.AntBuilder;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.StringUtils;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleBuildListener;

public class GrailsConsoleAntBuilder
extends AntBuilder {
    public GrailsConsoleAntBuilder(Project project) {
        super(project);
    }

    public GrailsConsoleAntBuilder() {
        super(GrailsConsoleAntBuilder.createAntProject());
    }

    protected static Project createAntProject() {
        Project project = new Project();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", (Object)helper);
        helper.getImportStack().addElement("AntBuilder");
        GrailsConsoleAntBuilder.addGrailsConsoleBuildListener(project);
        project.init();
        project.getBaseDir();
        return project;
    }

    public static void addGrailsConsoleBuildListener(Project project) {
        GrailsConsoleLogger logger = new GrailsConsoleLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        GrailsConsole instance = GrailsConsole.getInstance();
        project.addBuildListener((BuildListener)new GrailsConsoleBuildListener(instance));
        if (!instance.isVerbose()) {
            for (Object buildListener : project.getBuildListeners()) {
                if (!(buildListener instanceof BuildLogger)) continue;
                ((BuildLogger)buildListener).setMessageOutputLevel(LogLevel.ERR.getLevel());
            }
        }
    }

    private static class GrailsConsoleLogger
    extends DefaultLogger {
        protected String targetName;
        protected GrailsConsole console = GrailsConsole.getInstance();

        private GrailsConsoleLogger() {
        }

        public void targetStarted(BuildEvent event) {
            this.targetName = event.getTarget().getName();
        }

        public void targetFinished(BuildEvent event) {
            this.targetName = null;
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() > this.msgOutputLevel || null == event.getMessage() || "".equals(event.getMessage().trim())) {
                return;
            }
            if (null != this.targetName) {
                this.console.verbose(StringUtils.LINE_SEP + this.targetName + ":");
                this.targetName = null;
            }
        }
    }
}

