/*
 * Decompiled with CFR 0.152.
 */
package grails.build.logging;

import grails.util.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.completer.CompletionHandler;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.tools.ant.BuildException;
import org.codehaus.groovy.grails.cli.ScriptExitException;
import org.codehaus.groovy.grails.cli.interactive.CandidateListCompletionHandler;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleErrorPrintStream;
import org.codehaus.groovy.grails.cli.logging.GrailsConsolePrintStream;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.groovy.runtime.typehandling.NumberMath;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class GrailsConsole {
    private static GrailsConsole instance;
    public static final String ENABLE_TERMINAL = "grails.console.enable.terminal";
    public static final String ENABLE_INTERACTIVE = "grails.console.enable.interactive";
    public static final String LINE_SEPARATOR;
    public static final String CATEGORY_SEPARATOR = "|";
    public static final String PROMPT = "grails> ";
    public static final String SPACE = " ";
    public static final String ERROR = "Error";
    public static final String WARNING = "Warning";
    public static final String HISTORYFILE = ".grails_history";
    public static final String STACKTRACE_FILTERED_MESSAGE = " (NOTE: Stack trace has been filtered. Use --verbose to see entire trace.)";
    public static final String STACKTRACE_MESSAGE = " (Use --stacktrace to see the full trace)";
    public static final Character SECURE_MASK_CHAR;
    private final PrintStream originalSystemOut;
    private final PrintStream originalSystemErr;
    private StringBuilder maxIndicatorString;
    private int cursorMove = 1;
    private boolean verbose = Boolean.getBoolean("grails.verbose");
    private boolean stacktrace = Boolean.getBoolean("grails.show.stacktrace");
    private boolean progressIndicatorActive = false;
    String indicator = ".";
    String lastMessage = "";
    Ansi lastStatus = null;
    ConsoleReader reader;
    Terminal terminal;
    PrintStream out;
    PrintStream err;
    History history;
    Stack<String> category = new Stack<String>(){

        @Override
        public String toString() {
            if (this.size() == 1) {
                return (String)this.peek() + GrailsConsole.CATEGORY_SEPARATOR;
            }
            return DefaultGroovyMethods.join((Collection)this, (String)GrailsConsole.CATEGORY_SEPARATOR) + GrailsConsole.CATEGORY_SEPARATOR;
        }
    };
    private boolean ansiEnabled = true;
    private boolean userInputActive;
    private boolean appendCalled = false;

    protected GrailsConsole() throws IOException {
        this.originalSystemOut = System.out;
        this.originalSystemErr = System.err;
        this.out = new PrintStream(this.ansiWrap(this.originalSystemOut));
        this.err = new PrintStream(this.ansiWrap(this.originalSystemErr));
        System.setOut(new GrailsConsolePrintStream(this.out));
        System.setErr(new GrailsConsoleErrorPrintStream(this.err));
        System.setProperty("jline.shutdownhook", "false");
        if (this.isInteractiveEnabled()) {
            this.reader = this.createConsoleReader();
            this.reader.setBellEnabled(false);
            this.reader.setCompletionHandler((CompletionHandler)new CandidateListCompletionHandler());
            if (this.isActivateTerminal()) {
                this.terminal = this.createTerminal();
            }
            this.history = this.prepareHistory();
            if (this.history != null) {
                this.reader.setHistory(this.history);
            }
        } else if (this.isActivateTerminal()) {
            this.terminal = this.createTerminal();
        }
        this.maxIndicatorString = new StringBuilder(this.indicator).append(this.indicator).append(this.indicator).append(this.indicator).append(this.indicator);
    }

    public PrintStream getErr() {
        return this.err;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    private boolean isInteractiveEnabled() {
        return this.readPropOrTrue(ENABLE_INTERACTIVE);
    }

    private boolean isActivateTerminal() {
        return this.readPropOrTrue(ENABLE_TERMINAL);
    }

    private boolean readPropOrTrue(String prop) {
        String property = System.getProperty(prop);
        return property == null ? true : Boolean.valueOf(property);
    }

    protected ConsoleReader createConsoleReader() throws IOException {
        ConsoleReader consoleReader = new ConsoleReader(System.in, (OutputStream)this.out);
        consoleReader.setExpandEvents(false);
        return consoleReader;
    }

    protected Terminal createTerminal() {
        this.terminal = TerminalFactory.create();
        return this.terminal;
    }

    protected History prepareHistory() throws IOException {
        File file = new File(System.getProperty("user.home"), HISTORYFILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file.canWrite() ? new FileHistory(file) : null;
    }

    protected OutputStream ansiWrap(OutputStream out) {
        return AnsiConsole.wrapOutputStream((OutputStream)out);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    }

    public static synchronized GrailsConsole getInstance() {
        if (instance == null) {
            try {
                final GrailsConsole console = GrailsConsole.createInstance();
                GrailsConsole.setInstance(console);
                if (!Environment.isFork()) {
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                console.terminal.restore();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create grails console: " + e.getMessage(), e);
            }
        }
        return instance;
    }

    public static void setInstance(GrailsConsole newConsole) {
        instance = newConsole;
        if (!(System.out instanceof GrailsConsolePrintStream)) {
            System.setOut(new GrailsConsolePrintStream(GrailsConsole.instance.out));
        }
        if (!(System.err instanceof GrailsConsoleErrorPrintStream)) {
            System.setErr(new GrailsConsoleErrorPrintStream(GrailsConsole.instance.err));
        }
    }

    public static GrailsConsole createInstance() throws IOException {
        String className = System.getProperty("grails.console.class");
        if (className != null) {
            try {
                Class<?> klass = Class.forName(className);
                return (GrailsConsole)klass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new GrailsConsole();
    }

    public void setAnsiEnabled(boolean ansiEnabled) {
        this.ansiEnabled = ansiEnabled;
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            System.setProperty("grails.full.stacktrace", "true");
        }
        this.verbose = verbose;
    }

    public void setStacktrace(boolean stacktrace) {
        this.stacktrace = stacktrace;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isStacktrace() {
        return this.stacktrace;
    }

    public InputStream getInput() {
        this.assertAllowInput();
        return this.reader.getInput();
    }

    private void assertAllowInput() {
        this.assertAllowInput(null);
    }

    private void assertAllowInput(String prompt) {
        if (this.reader == null) {
            String msg = "User input is not enabled, cannot obtain input stream";
            if (prompt != null) {
                msg = msg + " - while trying: " + prompt;
            }
            throw new IllegalStateException(msg);
        }
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public Stack<String> getCategory() {
        return this.category;
    }

    public void indicateProgress() {
        this.verifySystemOut();
        this.progressIndicatorActive = true;
        if (this.isAnsiEnabled()) {
            if (this.lastMessage != null && this.lastMessage.length() > 0 && !this.lastMessage.contains(this.maxIndicatorString)) {
                this.updateStatus(this.lastMessage + this.indicator);
            }
        } else {
            this.out.print(this.indicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indicateProgress(int number, int total) {
        this.progressIndicatorActive = true;
        String currMsg = this.lastMessage;
        try {
            this.updateStatus(currMsg + ' ' + number + " of " + total);
        }
        finally {
            this.lastMessage = currMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indicateProgressPercentage(long number, long total) {
        this.verifySystemOut();
        this.progressIndicatorActive = true;
        String currMsg = this.lastMessage;
        try {
            int percentage = Math.round(NumberMath.multiply((Number)NumberMath.divide((Number)number, (Number)total), (Number)100).floatValue());
            if (!this.isAnsiEnabled()) {
                this.out.print("..");
                this.out.print(percentage + 37);
            } else {
                this.updateStatus(currMsg + ' ' + percentage + '%');
            }
        }
        finally {
            this.lastMessage = currMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indicateProgress(int number) {
        this.verifySystemOut();
        this.progressIndicatorActive = true;
        String currMsg = this.lastMessage;
        try {
            if (this.isAnsiEnabled()) {
                this.updateStatus(currMsg + ' ' + number);
            } else {
                this.out.print("..");
                this.out.print(number);
            }
        }
        finally {
            this.lastMessage = currMsg;
        }
    }

    public void updateStatus(String msg) {
        this.outputMessage(msg, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputMessage(String msg, int replaceCount) {
        this.verifySystemOut();
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        try {
            if (this.isAnsiEnabled()) {
                this.out.print(this.erasePreviousLine(CATEGORY_SEPARATOR));
                this.lastStatus = this.outputCategory(Ansi.ansi(), CATEGORY_SEPARATOR).fg(Ansi.Color.DEFAULT).a(msg).reset();
                this.out.println(this.lastStatus);
                if (!this.userInputActive) {
                    this.cursorMove = replaceCount;
                }
            } else {
                if (this.lastMessage != null && this.lastMessage.equals(msg)) {
                    return;
                }
                if (this.progressIndicatorActive) {
                    this.out.println();
                }
                this.out.print(CATEGORY_SEPARATOR);
                this.out.println(msg);
            }
            this.lastMessage = msg;
        }
        finally {
            this.postPrintMessage();
        }
    }

    private Ansi moveDownToSkipPrompt() {
        return Ansi.ansi().cursorDown(1).cursorLeft(PROMPT.length());
    }

    private void postPrintMessage() {
        this.progressIndicatorActive = false;
        this.appendCalled = false;
        if (this.userInputActive) {
            this.showPrompt();
        }
    }

    public void addStatus(String msg) {
        this.outputMessage(msg, 0);
        this.lastMessage = "";
    }

    public void error(String msg) {
        this.error(ERROR, msg);
    }

    public void warning(String msg) {
        this.error(WARNING, msg);
    }

    public void warn(String msg) {
        this.warning(msg);
    }

    private void logSimpleError(String msg) {
        this.verifySystemOut();
        if (this.progressIndicatorActive) {
            this.out.println();
        }
        this.out.println(CATEGORY_SEPARATOR);
        this.out.println(msg);
    }

    public boolean isAnsiEnabled() {
        return Ansi.isEnabled() && this.terminal != null && this.terminal.isAnsiSupported() && this.ansiEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg, Throwable error) {
        try {
            if ((this.verbose || this.stacktrace) && error != null) {
                this.printStackTrace(msg, error);
                this.error(ERROR, msg);
            } else {
                this.error(ERROR, msg + STACKTRACE_MESSAGE);
            }
        }
        finally {
            this.postPrintMessage();
        }
    }

    public void error(Throwable error) {
        this.printStackTrace(null, error);
    }

    private void printStackTrace(String message, Throwable error) {
        if (error instanceof ScriptExitException) {
            return;
        }
        if (error instanceof BuildException && error.getCause() != null) {
            error = error.getCause();
        }
        if (!this.isVerbose() && !Boolean.getBoolean("grails.full.stacktrace")) {
            StackTraceUtils.deepSanitize((Throwable)error);
        }
        StringWriter sw = new StringWriter();
        PrintWriter ps = new PrintWriter(sw);
        String string = message = message == null ? error.getMessage() : message;
        if (!this.isVerbose()) {
            message = message + STACKTRACE_FILTERED_MESSAGE;
        }
        ps.println(message);
        error.printStackTrace(ps);
        this.error(sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String msg) {
        this.verifySystemOut();
        PrintStream printStream = this.out;
        try {
            if (this.userInputActive) {
                this.erasePrompt(printStream);
            }
            if (msg.endsWith(LINE_SEPARATOR)) {
                printStream.print(msg);
            } else {
                printStream.println(msg);
            }
            this.cursorMove = 0;
        }
        finally {
            printStream.flush();
            this.postPrintMessage();
        }
    }

    private void erasePrompt(PrintStream printStream) {
        printStream.print(Ansi.ansi().eraseLine(Ansi.Erase.BACKWARD).cursorLeft(PROMPT.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String msg) {
        this.verifySystemOut();
        PrintStream printStream = this.out;
        try {
            if (this.userInputActive && !this.appendCalled) {
                printStream.print(this.moveDownToSkipPrompt());
                this.appendCalled = true;
            }
            if (msg.endsWith(LINE_SEPARATOR)) {
                printStream.print(msg);
            } else {
                printStream.println(msg);
            }
            this.cursorMove = 0;
        }
        finally {
            this.progressIndicatorActive = false;
        }
    }

    public void info(String msg) {
        this.log(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verbose(String msg) {
        this.verifySystemOut();
        try {
            if (this.verbose) {
                this.out.println(msg);
                this.cursorMove = 0;
            }
        }
        finally {
            this.postPrintMessage();
        }
    }

    public void echoStatus() {
        if (this.lastStatus != null) {
            this.updateStatus(this.lastStatus.toString());
        }
    }

    public String userInput(String msg) {
        return this.doUserInput(msg, false);
    }

    public String secureUserInput(String msg) {
        return this.doUserInput(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doUserInput(String msg, boolean secure) {
        if (!msg.endsWith(SPACE) && !msg.endsWith("\t")) {
            msg = msg + ' ';
        }
        this.lastMessage = "";
        msg = this.isAnsiEnabled() ? this.outputCategory(Ansi.ansi(), ">").fg(Ansi.Color.DEFAULT).a(msg).reset().toString() : msg;
        try {
            String string = this.readLine(msg, secure);
            return string;
        }
        finally {
            this.cursorMove = 0;
        }
    }

    private String showPrompt(String prompt) {
        this.verifySystemOut();
        this.cursorMove = 0;
        if (!this.userInputActive) {
            return this.readLine(prompt, false);
        }
        this.out.print(prompt);
        this.out.flush();
        return null;
    }

    private String readLine(String prompt, boolean secure) {
        this.assertAllowInput(prompt);
        this.userInputActive = true;
        try {
            String string = secure ? this.reader.readLine(prompt, SECURE_MASK_CHAR) : this.reader.readLine(prompt);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading input: " + e.getMessage());
        }
        finally {
            this.userInputActive = false;
        }
    }

    public String showPrompt() {
        String prompt = this.isAnsiEnabled() ? this.ansiPrompt(PROMPT).toString() : PROMPT;
        return this.showPrompt(prompt);
    }

    private Ansi ansiPrompt(String prompt) {
        return Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.YELLOW).a(prompt).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT);
    }

    public String userInput(String message, List<String> validResponses) {
        return this.userInput(message, validResponses.toArray(new String[validResponses.size()]));
    }

    public String userInput(String message, String[] validResponses) {
        if (validResponses == null) {
            return this.userInput(message);
        }
        String question = this.createQuestion(message, validResponses);
        String response = this.userInput(question);
        for (String validResponse : validResponses) {
            if (!validResponse.equalsIgnoreCase(response)) continue;
            return response;
        }
        this.cursorMove = 0;
        return this.userInput("Invalid input. Must be one of ", validResponses);
    }

    private String createQuestion(String message, String[] validResponses) {
        return message + "[" + DefaultGroovyMethods.join((Object[])validResponses, (String)",") + "] ";
    }

    private Ansi outputCategory(Ansi ansi, String categoryName) {
        return ansi.a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.YELLOW).a(categoryName).a(SPACE).a(Ansi.Attribute.INTENSITY_BOLD_OFF);
    }

    private Ansi outputErrorLabel(Ansi ansi, String label) {
        return ansi.a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.RED).a(CATEGORY_SEPARATOR).a(SPACE).a(label).a(SPACE).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT);
    }

    private Ansi erasePreviousLine(String categoryName) {
        int cursorMove = this.cursorMove;
        if (this.userInputActive) {
            ++cursorMove;
        }
        if (cursorMove > 0) {
            int moveLeftLength = categoryName.length() + this.lastMessage.length();
            if (this.userInputActive) {
                moveLeftLength += PROMPT.length();
            }
            return Ansi.ansi().cursorUp(cursorMove).cursorLeft(moveLeftLength).eraseLine(Ansi.Erase.FORWARD);
        }
        return Ansi.ansi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String label, String message) {
        this.verifySystemOut();
        if (message == null) {
            return;
        }
        this.cursorMove = 0;
        try {
            if (this.isAnsiEnabled()) {
                Ansi ansi = this.outputErrorLabel(this.userInputActive ? this.moveDownToSkipPrompt() : Ansi.ansi(), label).a(message).reset();
                if (message.endsWith(LINE_SEPARATOR)) {
                    this.out.print(ansi);
                } else {
                    this.out.println(ansi);
                }
            } else {
                this.out.print(label);
                this.out.print(SPACE);
                this.logSimpleError(message);
            }
        }
        finally {
            this.postPrintMessage();
        }
    }

    private void verifySystemOut() {
        if (!(System.out instanceof GrailsConsolePrintStream)) {
            System.setOut(new GrailsConsolePrintStream(this.originalSystemOut));
        }
        if (!(System.err instanceof GrailsConsoleErrorPrintStream)) {
            System.setErr(new GrailsConsoleErrorPrintStream(this.originalSystemErr));
        }
    }

    public void flush() {
        this.out.flush();
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        SECURE_MASK_CHAR = new Character('*');
    }
}

