/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.codehaus.groovy.grails.plugins.GrailsVersionUtils;
import org.codehaus.groovy.grails.resolve.Dependency;

public class GrailsCoreDependencies {
    public final String grailsVersion;
    public final String servletVersion;
    protected final String groovyVersion = "2.1.9";
    protected final String log4jVersion = "1.2.17";
    protected final String h2Version = "1.3.176";
    protected final String jaxbVersion = "2.0";
    protected String servletApiVersion = "3.0.1";
    protected String spockVersion = "0.7-groovy-2.0";
    protected String junitVersion = "4.11";
    public boolean java5compatible;
    protected Collection<Dependency> buildDependencies;
    protected Collection<Dependency> docDependencies;
    protected Collection<Dependency> providedDependencies;
    protected Collection<Dependency> compileDependencies;
    protected Collection<Dependency> runtimeDependencies;
    protected Collection<Dependency> testDependencies;

    public GrailsCoreDependencies(String grailsVersion) {
        this(grailsVersion, "2.5", false, true);
    }

    public GrailsCoreDependencies(String grailsVersion, String servletVersion) {
        this(grailsVersion, servletVersion, false, true);
    }

    public GrailsCoreDependencies(String grailsVersion, String servletVersion, boolean java5compatible, boolean isGrailsProject) {
        this.grailsVersion = grailsVersion;
        this.servletVersion = servletVersion == null ? "2.5" : servletVersion;
        this.java5compatible = java5compatible;
        this.buildDependencies = Arrays.asList(new Dependency("xalan", "serializer", "2.7.1", true, "xml-apis:xml-apis"), new Dependency("org.grails", "grails-bootstrap", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-scripts", grailsVersion, true, new String[0]));
        this.docDependencies = Arrays.asList(new Dependency("org.grails", "grails-docs", grailsVersion, true, new String[0]));
        this.providedDependencies = Arrays.asList(new Dependency("javax.servlet", "javax.servlet-api", this.servletApiVersion, true, new String[0]));
        this.compileDependencies = Arrays.asList(new Dependency("org.codehaus.groovy", "groovy-all", "2.1.9", true, new String[0]), new Dependency("org.grails", "grails-plugin-rest", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-databinding", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-i18n", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-filters", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-gsp", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-log4j", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-services", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-servlets", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-url-mappings", grailsVersion, true, new String[0]));
        if (GrailsVersionUtils.isValidVersion(servletVersion, "3.0 > *")) {
            this.compileDependencies = new ArrayList<Dependency>(this.compileDependencies);
            this.compileDependencies.add(new Dependency("org.grails", "grails-plugin-async", grailsVersion, true, "javax:javaee-web-api"));
        }
        if (isGrailsProject) {
            String[] spockExcludes = new String[]{"org.codehaus.groovy:groovy-all", "junit:junit-dep"};
            this.testDependencies = Arrays.asList(new Dependency("org.grails", "grails-plugin-testing", grailsVersion, true, new String[0]), new Dependency("org.spockframework", "spock-core", this.spockVersion, true, spockExcludes), new Dependency("junit", "junit", this.junitVersion, true, new String[0]));
        } else {
            this.testDependencies = Arrays.asList(new Dependency("org.grails", "grails-plugin-testing", grailsVersion, true, new String[0]));
        }
        String[] loggingExcludes = new String[]{"javax.mail:mail", "javax.jms:jms", "com.sun.jdmk:jmxtools", "com.sun.jmx:jmxri"};
        this.runtimeDependencies = Arrays.asList(new Dependency("com.h2database", "h2", "1.3.176", true, new String[0]), new Dependency("log4j", "log4j", "1.2.17", true, loggingExcludes), new Dependency("org.grails", "grails-resources", grailsVersion, true, new String[0]));
        if (java5compatible) {
            this.compileDependencies = new ArrayList<Dependency>(this.compileDependencies);
            this.compileDependencies.add(new Dependency("javax.xml", "jaxb-api", "2.0", true, new String[0]));
        }
    }

    public void setJava5compatible(boolean java5compatible) {
        this.java5compatible = java5compatible;
    }

    public String getGrailsVersion() {
        return this.grailsVersion;
    }

    public boolean isJava5compatible() {
        return this.java5compatible;
    }

    public Collection<Dependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    public Collection<Dependency> getDocDependencies() {
        return this.docDependencies;
    }

    public Collection<Dependency> getProvidedDependencies() {
        return this.providedDependencies;
    }

    public Collection<Dependency> getCompileDependencies() {
        return this.compileDependencies;
    }

    public Collection<Dependency> getRuntimeDependencies() {
        return this.runtimeDependencies;
    }

    public Collection<Dependency> getTestDependencies() {
        return this.testDependencies;
    }

    public Collection<String> getBuildDependencyPatterns() {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Dependency buildDependency : this.buildDependencies) {
            dependencies.add(buildDependency.getPattern());
        }
        return dependencies;
    }
}

