/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import groovy.util.ConfigObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractBuildSettings {
    private static final String KEY_PLUGIN_DIRECTORY_RESOURCES = "pluginDirectoryResources";
    private static final String KEY_INLINE_PLUGIN_LOCATIONS = "inlinePluginLocations";
    private static final String KEY_PLUGIN_BASE_DIRECTORIES = "pluginBaseDirectories";
    protected Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    protected ConfigObject config = new ConfigObject();
    protected File projectPluginsDir;
    protected File globalPluginsDir;
    protected boolean projectPluginsDirSet;
    protected boolean globalPluginsDirSet;
    protected Map flatConfig = Collections.emptyMap();

    abstract File getBaseDir();

    void clearCache() {
        this.cache.clear();
    }

    public ConfigObject getConfig() {
        return this.config;
    }

    public void setConfig(ConfigObject config) {
        this.config = config;
    }

    public File getProjectPluginsDir() {
        return this.projectPluginsDir;
    }

    public void setProjectPluginsDir(File projectPluginsDir) {
        this.projectPluginsDir = projectPluginsDir;
        this.projectPluginsDirSet = true;
    }

    public File getGlobalPluginsDir() {
        return this.globalPluginsDir;
    }

    public void setGlobalPluginsDir(File globalPluginsDir) {
        this.globalPluginsDir = globalPluginsDir;
        this.globalPluginsDirSet = true;
    }

    public void addPluginDirectory(File location, boolean isInline) {
        Collection<File> directories;
        this.getPluginDirectories();
        if (location != null && !(directories = this.getPluginDirectories()).contains(location)) {
            directories.add(location);
            if (isInline) {
                this.getInlinePluginDirectories().add(location);
            }
        }
    }

    public Collection<File> getPluginDirectories() {
        Collection<File> pluginDirectoryResources = (Collection<File>)this.cache.get(KEY_PLUGIN_DIRECTORY_RESOURCES);
        if (pluginDirectoryResources == null) {
            pluginDirectoryResources = this.getImplicitPluginDirectories();
            Collection<File> inlinePlugins = this.getInlinePluginsFromConfiguration((Map)this.config);
            this.cache.put(KEY_INLINE_PLUGIN_LOCATIONS, inlinePlugins);
            ArrayList<File> list = new ArrayList<File>(pluginDirectoryResources);
            list.addAll(inlinePlugins);
            Collections.reverse(list);
            pluginDirectoryResources = new ConcurrentLinkedQueue<File>(list);
            this.cache.put(KEY_PLUGIN_DIRECTORY_RESOURCES, pluginDirectoryResources);
        }
        return pluginDirectoryResources;
    }

    protected Collection<File> getInlinePluginsFromConfiguration(Map config) {
        return this.getInlinePluginsFromConfiguration(config, this.getBaseDir());
    }

    protected Collection<File> getInlinePluginsFromConfiguration(Map config, File baseDir) {
        Map pluginLocations;
        ConcurrentLinkedQueue<File> inlinePlugins = new ConcurrentLinkedQueue<File>();
        if (config != null && (pluginLocations = this.lookupPluginLocationConfig(config)) != null) {
            for (Object value : pluginLocations.values()) {
                if (value == null) continue;
                try {
                    File resource = new File(value.toString());
                    if (!resource.isAbsolute()) {
                        resource = new File(baseDir, resource.getPath());
                    }
                    resource = resource.getCanonicalFile();
                    inlinePlugins.add(resource);
                }
                catch (IOException e) {
                    System.err.println("Cannot add location [" + value + "] as an inline plugin dependencies due to I/O error: " + e.getMessage());
                }
            }
        }
        return inlinePlugins;
    }

    private Map lookupPluginLocationConfig(Map config) {
        return this.getIfMap(this.getIfMap(this.getIfMap(config, "grails"), "plugin"), "location");
    }

    private Map getIfMap(Map config, String name) {
        Object o;
        if (config != null && (o = config.get(name)) instanceof Map) {
            return (Map)o;
        }
        return Collections.emptyMap();
    }

    public Collection<File> getImplicitPluginDirectories() {
        ConcurrentLinkedQueue<File> dirList = new ConcurrentLinkedQueue<File>();
        for (String pluginBase : this.getPluginBaseDirectories()) {
            File[] pluginDirs = new File(pluginBase).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    return pathname.isDirectory() && !fileName.startsWith(".") && fileName.indexOf(45) > -1;
                }
            });
            if (pluginDirs == null) continue;
            dirList.addAll(Arrays.asList(pluginDirs));
        }
        return dirList;
    }

    public Collection<String> getPluginBaseDirectories() {
        ArrayList<String> dirs = (ArrayList<String>)this.cache.get(KEY_PLUGIN_BASE_DIRECTORIES);
        if (dirs == null) {
            dirs = new ArrayList<String>();
            if (this.projectPluginsDir != null) {
                try {
                    dirs.add(this.projectPluginsDir.getCanonicalPath());
                }
                catch (IOException e) {
                    System.err.println("Cannot read project plugins directory [" + this.projectPluginsDir + "] due to I/O error: " + e.getMessage());
                }
            }
            if (this.globalPluginsDir != null) {
                try {
                    dirs.add(this.globalPluginsDir.getCanonicalPath());
                }
                catch (IOException e) {
                    System.err.println("Cannot read global plugins directory [" + this.globalPluginsDir + "] due to I/O error: " + e.getMessage());
                }
            }
            this.cache.put(KEY_PLUGIN_BASE_DIRECTORIES, dirs);
        }
        return dirs;
    }

    public boolean isInlinePluginLocation(File pluginLocation) {
        if (pluginLocation == null) {
            return false;
        }
        this.getPluginDirectories();
        ConcurrentLinkedQueue locations = (ConcurrentLinkedQueue)this.cache.get(KEY_INLINE_PLUGIN_LOCATIONS);
        try {
            return locations != null && (locations.contains(pluginLocation) || locations.contains(pluginLocation.getCanonicalFile()));
        }
        catch (IOException e) {
            return false;
        }
    }

    public Collection<File> getInlinePluginDirectories() {
        this.getPluginDirectories();
        ConcurrentLinkedQueue locations = (ConcurrentLinkedQueue)this.cache.get(KEY_INLINE_PLUGIN_LOCATIONS);
        if (locations == null) {
            locations = new ConcurrentLinkedQueue();
            this.cache.put(KEY_INLINE_PLUGIN_LOCATIONS, locations);
        }
        return locations;
    }
}

