/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.codehaus.groovy.grails.plugins.GrailsVersionUtils;
import org.codehaus.groovy.grails.resolve.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsCoreDependencies {
    public final String grailsVersion;
    public final String servletVersion;
    protected final String groovyVersion = "2.1.3";
    protected final String log4jVersion = "1.2.17";
    protected final String h2Version = "1.3.170";
    protected final String jaxbVersion = "2.0";
    private String servletApiVersion = "3.0.1";
    public boolean java5compatible;
    protected Collection<Dependency> buildDependencies;
    protected Collection<Dependency> docDependencies;
    protected Collection<Dependency> providedDependencies;
    protected Collection<Dependency> compileDependencies;
    protected Collection<Dependency> runtimeDependencies;
    protected Collection<Dependency> testDependencies;

    public GrailsCoreDependencies(String grailsVersion) {
        this(grailsVersion, "2.5", false);
    }

    public GrailsCoreDependencies(String grailsVersion, String servletVersion) {
        this(grailsVersion, servletVersion, false);
    }

    public GrailsCoreDependencies(String grailsVersion, String servletVersion, boolean java5compatible) {
        this.grailsVersion = grailsVersion;
        this.servletVersion = servletVersion == null ? "2.5" : servletVersion;
        this.java5compatible = java5compatible;
        this.buildDependencies = Arrays.asList(new Dependency("xalan", "serializer", "2.7.1", true, "xml-apis:xml-apis"), new Dependency("org.grails", "grails-bootstrap", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-scripts", grailsVersion, true, new String[0]));
        this.docDependencies = Arrays.asList(new Dependency("org.grails", "grails-docs", grailsVersion, true, new String[0]), new Dependency("com.lowagie", "itext", "2.0.8", true, new String[0]));
        this.providedDependencies = Arrays.asList(new Dependency("javax.servlet", "javax.servlet-api", this.servletApiVersion, true, new String[0]));
        this.compileDependencies = Arrays.asList(new Dependency("org.codehaus.groovy", "groovy-all", "2.1.3", true, new String[0]), new Dependency("org.grails", "grails-plugin-codecs", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-controllers", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-domain-class", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-converters", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-datasource", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-databinding", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-filters", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-gsp", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-i18n", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-log4j", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-services", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-servlets", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-mimetypes", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-url-mappings", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-plugin-validation", grailsVersion, true, new String[0]));
        if (GrailsVersionUtils.isValidVersion(servletVersion, "3.0 > *")) {
            this.compileDependencies = new ArrayList<Dependency>(this.compileDependencies);
            this.compileDependencies.add(new Dependency("org.grails", "grails-plugin-async", grailsVersion, true, "javax:javaee-web-api"));
        }
        this.testDependencies = Arrays.asList(new Dependency("org.grails", "grails-plugin-testing", grailsVersion, true, new String[0]), new Dependency("org.grails", "grails-test", grailsVersion, true, new String[0]));
        String[] loggingExcludes = new String[]{"javax.mail:mail", "javax.jms:jms", "com.sun.jdmk:jmxtools", "com.sun.jmx:jmxri"};
        this.runtimeDependencies = Arrays.asList(new Dependency("com.h2database", "h2", "1.3.170", true, new String[0]), new Dependency("log4j", "log4j", "1.2.17", true, loggingExcludes), new Dependency("org.grails", "grails-resources", grailsVersion, true, new String[0]));
        if (java5compatible) {
            this.compileDependencies = new ArrayList<Dependency>(this.compileDependencies);
            this.runtimeDependencies.add(new Dependency("javax.xml", "jaxb-api", "2.0", true, new String[0]));
        }
    }

    public void setJava5compatible(boolean java5compatible) {
        this.java5compatible = java5compatible;
    }

    public String getGrailsVersion() {
        return this.grailsVersion;
    }

    public boolean isJava5compatible() {
        return this.java5compatible;
    }

    public Collection<Dependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    public Collection<Dependency> getDocDependencies() {
        return this.docDependencies;
    }

    public Collection<Dependency> getProvidedDependencies() {
        return this.providedDependencies;
    }

    public Collection<Dependency> getCompileDependencies() {
        return this.compileDependencies;
    }

    public Collection<Dependency> getRuntimeDependencies() {
        return this.runtimeDependencies;
    }

    public Collection<Dependency> getTestDependencies() {
        return this.testDependencies;
    }

    public Collection<String> getBuildDependencyPatterns() {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Dependency buildDependency : this.buildDependencies) {
            dependencies.add(buildDependency.getPattern());
        }
        return dependencies;
    }
}

