/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.BasicGrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.PluginDescriptorReader;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class AstPluginDescriptorReader
implements PluginDescriptorReader {
    private GroovyClassLoader classLoader;

    public AstPluginDescriptorReader() {
        this(new GroovyClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public AstPluginDescriptorReader(GroovyClassLoader cl) {
        this.classLoader = cl;
    }

    public GrailsPluginInfo readPluginInfo(Resource pluginLocation) {
        CompilationUnit compilationUnit = new CompilationUnit(this.classLoader);
        BasicGrailsPluginInfo pluginInfo = new BasicGrailsPluginInfo(pluginLocation);
        try {
            compilationUnit.addSource("dummy", pluginLocation.getInputStream());
            compilationUnit.addPhaseOperation((CompilationUnit.PrimaryClassNodeOperation)new PluginReadingPhaseOperation(pluginInfo), 3);
            compilationUnit.compile(3);
            return pluginInfo;
        }
        catch (IOException e) {
            throw new PluginException("Cannot read plugin info: " + e.getMessage());
        }
    }

    class PluginReadingPhaseOperation
    extends CompilationUnit.PrimaryClassNodeOperation {
        private BasicGrailsPluginInfo pluginInfo;
        private MetaClass pluginInfoMetaClass;

        public PluginReadingPhaseOperation(BasicGrailsPluginInfo pluginInfo) {
            this.pluginInfo = pluginInfo;
            this.pluginInfoMetaClass = pluginInfo.getMetaClass();
        }

        public void call(final SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

                public void visitProperty(PropertyNode node) {
                    String name = node.getName();
                    Expression expr = node.getField().getInitialExpression();
                    if (expr != null) {
                        LinkedHashMap<String, String> value;
                        if (expr instanceof ListExpression) {
                            ArrayList<String> list = new ArrayList<String>();
                            value = list;
                            for (Expression i : ((ListExpression)expr).getExpressions()) {
                                list.add(i.getText());
                            }
                        } else if (expr instanceof MapExpression) {
                            LinkedHashMap<String, String> map;
                            value = map = new LinkedHashMap<String, String>();
                            for (MapEntryExpression mee : ((MapExpression)expr).getMapEntryExpressions()) {
                                map.put(mee.getKeyExpression().getText(), mee.getValueExpression().getText());
                            }
                        } else {
                            value = expr.getText();
                        }
                        if (DefaultGroovyMethods.hasProperty((Object)PluginReadingPhaseOperation.this.pluginInfo, (String)name) != null) {
                            PluginReadingPhaseOperation.this.pluginInfoMetaClass.setProperty((Object)PluginReadingPhaseOperation.this.pluginInfo, name, value);
                        } else {
                            PluginReadingPhaseOperation.this.pluginInfo.setProperty(name, value);
                        }
                        super.visitProperty(node);
                    }
                }

                protected SourceUnit getSourceUnit() {
                    return source;
                }
            };
            classNode.visitContents((GroovyClassVisitor)visitor);
            String className = classNode.getNameWithoutPackage();
            this.pluginInfoMetaClass.setProperty((Object)this.pluginInfo, "name", (Object)GrailsNameUtils.getPluginName(className + ".groovy"));
        }
    }
}

