/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import grails.util.Holder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata
extends Properties {
    private static final long serialVersionUID = -582452926111226898L;
    public static final String FILE = "application.properties";
    public static final String APPLICATION_VERSION = "app.version";
    public static final String APPLICATION_NAME = "app.name";
    public static final String APPLICATION_GRAILS_VERSION = "app.grails.version";
    public static final String SERVLET_VERSION = "app.servlet.version";
    public static final String WAR_DEPLOYED = "grails.war.deployed";
    public static final String DEFAULT_SERVLET_VERSION = "2.5";
    private static Holder<Reference<Metadata>> holder = new Holder("Metadata");
    private File metadataFile;
    private boolean warDeployed;

    private Metadata() {
        this.loadFromDefault();
    }

    private Metadata(File f) {
        this.metadataFile = f;
        this.loadFromFile(f);
    }

    private Metadata(InputStream inputStream) {
        this.loadFromInputStream(inputStream);
    }

    private Metadata(Map<?, ?> properties) {
        this.putAll(properties);
        this.afterLoading();
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public static void reset() {
        Metadata m = Metadata.getFromMap();
        if (m != null) {
            m.clear();
            m.afterLoading();
        }
    }

    private void afterLoading() {
        this.warDeployed = "true".equals(this.get(WAR_DEPLOYED));
    }

    public static Metadata getCurrent() {
        Metadata m = Metadata.getFromMap();
        if (m == null) {
            m = new Metadata();
            holder.set(new SoftReference<Metadata>(m));
        }
        return m;
    }

    private void loadFromDefault() {
        InputStream input = null;
        try {
            input = Thread.currentThread().getContextClassLoader().getResourceAsStream(FILE);
            if (input == null) {
                input = Metadata.class.getClassLoader().getResourceAsStream(FILE);
            }
            if (input != null) {
                this.load(input);
            }
            this.afterLoading();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Metadata.closeQuietly(input);
                throw throwable;
            }
        }
        Metadata.closeQuietly(input);
    }

    private void loadFromInputStream(InputStream inputStream) {
        try {
            this.load(inputStream);
            this.afterLoading();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
        }
    }

    private void loadFromFile(File file) {
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                this.load(input);
                this.afterLoading();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Metadata.closeQuietly(input);
                    throw throwable;
                }
            }
            Metadata.closeQuietly(input);
        }
    }

    public static Metadata getInstance(InputStream inputStream) {
        Metadata m = new Metadata(inputStream);
        holder.set(new FinalReference<Metadata>(m));
        return m;
    }

    public static Metadata getInstance(File file) {
        Metadata m = new Metadata(file);
        holder.set(new FinalReference<Metadata>(m));
        return m;
    }

    public static Metadata reload() {
        File f = Metadata.getCurrent().metadataFile;
        if (f != null && f.exists()) {
            return Metadata.getInstance(f);
        }
        return f == null ? new Metadata() : new Metadata(f);
    }

    public String getApplicationVersion() {
        return (String)this.get(APPLICATION_VERSION);
    }

    public String getGrailsVersion() {
        return (String)this.get(APPLICATION_GRAILS_VERSION);
    }

    public String getEnvironment() {
        return (String)this.get(Environment.KEY);
    }

    public String getApplicationName() {
        return (String)this.get(APPLICATION_NAME);
    }

    public Map<String, String> getInstalledPlugins() {
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            if (!key.startsWith("plugins.") || val == null) continue;
            newMap.put(key.substring(8), val.toString());
        }
        return newMap;
    }

    public String getServletVersion() {
        String servletVersion = (String)this.get(SERVLET_VERSION);
        if (servletVersion == null) {
            servletVersion = System.getProperty(SERVLET_VERSION) != null ? System.getProperty(SERVLET_VERSION) : DEFAULT_SERVLET_VERSION;
            return servletVersion;
        }
        return servletVersion;
    }

    public void persist() {
        if (this.propertiesHaveNotChanged()) {
            return;
        }
        if (this.metadataFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.metadataFile);
                this.store(out, "Grails Metadata file");
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Error persisting metadata to file [" + this.metadataFile + "]: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Metadata.closeQuietly(out);
                    throw throwable;
                }
            }
            Metadata.closeQuietly(out);
        }
    }

    public boolean propertiesHaveNotChanged() {
        Metadata transientMetadata = this;
        Metadata allStringValuesMetadata = new Metadata();
        Metadata transientMap = transientMetadata;
        for (Map.Entry entry : transientMap.entrySet()) {
            if (entry.getValue() == null) continue;
            allStringValuesMetadata.put(entry.getKey().toString(), entry.getValue().toString());
        }
        Metadata persistedMetadata = Metadata.reload();
        boolean result = allStringValuesMetadata.equals(persistedMetadata);
        holder.set(new SoftReference<Metadata>(transientMetadata));
        return result;
    }

    @Override
    public synchronized Enumeration keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList);
        return keyList.elements();
    }

    public boolean isWarDeployed() {
        return this.warDeployed;
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Metadata getFromMap() {
        Reference<Metadata> metadata = holder.get();
        return metadata == null ? null : metadata.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FinalReference<T>
    extends SoftReference<T> {
        private T ref;

        public FinalReference(T t) {
            super(t);
            this.ref = t;
        }

        @Override
        public T get() {
            return this.ref;
        }
    }
}

