/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Metadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    DEVELOPMENT,
    PRODUCTION,
    TEST,
    APPLICATION,
    CUSTOM;

    public static String KEY;
    public static String RELOAD_ENABLED;
    public static final String RELOAD_LOCATION = "grails.reload.location";
    public static final String DEFAULT = "grails.env.default";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static HashMap<String, String> envNameMappings;
    private String name;

    public static Environment getCurrent() {
        String envName = System.getProperty(KEY);
        Metadata metadata = Metadata.getCurrent();
        if (metadata != null && Environment.isBlank(envName)) {
            envName = metadata.getEnvironment();
        }
        if (Environment.isBlank(envName)) {
            return DEVELOPMENT;
        }
        Environment env = Environment.getEnvironment(envName);
        if (env == null) {
            try {
                env = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (env == null) {
            env = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static boolean isDevelopmentMode() {
        return Environment.getCurrent() == DEVELOPMENT && !Metadata.getCurrent().isWarDeployed() && System.getProperty("grails.home") != null;
    }

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = envNameMappings.get(shortName);
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        return null;
    }

    public static Closure getEnvironmentSpecificBlock(Closure closure) {
        Environment env = Environment.getCurrent();
        return Environment.getEnvironmentSpecificBlock(env, closure);
    }

    public static Closure getEnvironmentSpecificBlock(Environment env, Closure closure) {
        if (closure != null) {
            EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
            return evaluator.getCallable();
        }
        return null;
    }

    public static Object executeForCurrentEnvironment(Closure closure) {
        Environment env = Environment.getCurrent();
        return Environment.executeForEnvironment(env, closure);
    }

    public static Object executeForEnvironment(Environment env, Closure closure) {
        if (closure != null) {
            EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
            return evaluator.execute();
        }
        return null;
    }

    private static EnvironmentBlockEvaluator evaluateEnvironmentSpecificBlock(Environment environment, Closure closure) {
        EnvironmentBlockEvaluator evaluator = new EnvironmentBlockEvaluator(environment);
        closure.setDelegate((Object)evaluator);
        closure.setResolveStrategy(1);
        closure.call();
        return evaluator;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        if (this.name == null) {
            return this.toString().toLowerCase(Locale.getDefault());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReloadEnabled() {
        boolean reloadOverride = Boolean.getBoolean(RELOAD_ENABLED);
        String reloadLocation = this.getReloadLocationInternal();
        boolean reloadLocationSpecified = this.isNotBlank(reloadLocation);
        return this == DEVELOPMENT && reloadLocationSpecified && !Metadata.getCurrent().isWarDeployed() || reloadOverride && reloadLocationSpecified;
    }

    private boolean isNotBlank(String reloadLocation) {
        return reloadLocation != null && reloadLocation.length() > 0;
    }

    public String getReloadLocation() {
        String location = this.getReloadLocationInternal();
        if (this.isNotBlank(location)) {
            return location;
        }
        return ".";
    }

    public boolean hasReloadLocation() {
        return this.isNotBlank(this.getReloadLocationInternal());
    }

    private String getReloadLocationInternal() {
        BuildSettings settings;
        String location = System.getProperty(RELOAD_LOCATION);
        if (!this.isNotBlank(location)) {
            location = System.getProperty(BuildSettings.APP_BASE_DIR);
        }
        if (!this.isNotBlank(location) && (settings = BuildSettingsHolder.getSettings()) != null) {
            location = settings.getBaseDir().getAbsolutePath();
        }
        return location;
    }

    static {
        KEY = "grails.env";
        RELOAD_ENABLED = "grails.reload.enabled";
        envNameMappings = new HashMap<String, String>(){
            {
                this.put(Environment.DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName());
                this.put(Environment.PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName());
                this.put(Environment.TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
            }
        };
    }

    private static class EnvironmentBlockEvaluator
    extends GroovyObjectSupport {
        private Environment current;
        private Closure callable;

        public Closure getCallable() {
            return this.callable;
        }

        Object execute() {
            if (this.callable != null) {
                return this.callable.call();
            }
            return null;
        }

        private EnvironmentBlockEvaluator(Environment e) {
            this.current = e;
        }

        void environments(Closure callable) {
            if (callable != null) {
                callable.setDelegate((Object)this);
                callable.setResolveStrategy(1);
                callable.call();
            }
        }

        void production(Closure callable) {
            if (this.current == PRODUCTION) {
                this.callable = callable;
            }
        }

        void development(Closure callable) {
            if (this.current == DEVELOPMENT) {
                this.callable = callable;
            }
        }

        void test(Closure callable) {
            if (this.current == TEST) {
                this.callable = callable;
            }
        }

        Object methodMissing(String name, Object args) {
            Object[] argsArray = (Object[])args;
            if (args != null && argsArray.length > 0 && argsArray[0] instanceof Closure) {
                if (this.current == CUSTOM && this.current.getName().equals(name)) {
                    this.callable = (Closure)argsArray[0];
                }
                return null;
            }
            throw new MissingMethodException(name, Environment.class, argsArray);
        }
    }
}

