/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import java.io.File;
import java.net.URLClassLoader;
import java.util.List;

public class GrailsBuildHelper {
    private ClassLoader classLoader;
    private Object settings;

    public GrailsBuildHelper(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public GrailsBuildHelper(ClassLoader classLoader, String grailsHome) {
        this(classLoader, grailsHome, null);
    }

    public GrailsBuildHelper(ClassLoader classLoader, String grailsHome, String baseDir) {
        try {
            this.classLoader = classLoader;
            Class<?> clazz = classLoader.loadClass("grails.util.BuildSettings");
            File grailsHomeFile = grailsHome == null ? null : new File(grailsHome);
            File baseDirFile = baseDir == null ? null : new File(baseDir);
            this.settings = clazz.getConstructor(File.class, File.class).newInstance(grailsHomeFile, baseDirFile);
            this.invokeMethod(this.settings, "setRootLoader", new Class[]{URLClassLoader.class}, new Object[]{classLoader});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public int execute(String script) {
        return this.execute(script, null);
    }

    public int execute(String script, String args) {
        try {
            Object scriptRunner = this.createScriptRunner();
            Object retval = scriptRunner.getClass().getMethod("executeCommand", String.class, String.class).invoke(scriptRunner, script, args);
            return (Integer)retval;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public int execute(String script, String args, String env) {
        try {
            Object scriptRunner = this.createScriptRunner();
            Object retval = scriptRunner.getClass().getMethod("executeCommand", String.class, String.class, String.class).invoke(scriptRunner, script, args, env);
            return (Integer)retval;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public File getGrailsWorkDir() {
        return (File)this.invokeMethod(this.settings, "getGrailsWorkDir", new Object[0]);
    }

    public void setGrailsWorkDir(File dir) {
        this.invokeMethod(this.settings, "setGrailsWorkDir", new Object[]{dir});
    }

    public File getProjectWorkDir() {
        return (File)this.invokeMethod(this.settings, "getProjectWorkDir", new Object[0]);
    }

    public void setProjectWorkDir(File dir) {
        this.invokeMethod(this.settings, "setProjectWorkDir", new Object[]{dir});
    }

    public File getClassesDir() {
        return (File)this.invokeMethod(this.settings, "getClassesDir", new Object[0]);
    }

    public void setClassesDir(File dir) {
        this.invokeMethod(this.settings, "setClassesDir", new Object[]{dir});
    }

    public File getTestClassesDir() {
        return (File)this.invokeMethod(this.settings, "getTestClassesDir", new Object[0]);
    }

    public void setTestClassesDir(File dir) {
        this.invokeMethod(this.settings, "setTestClassesDir", new Object[]{dir});
    }

    public File getResourcesDir() {
        return (File)this.invokeMethod(this.settings, "getResourcesDir", new Object[0]);
    }

    public void setResourcesDir(File dir) {
        this.invokeMethod(this.settings, "setResourcesDir", new Object[]{dir});
    }

    public File getProjectPluginsDir() {
        return (File)this.invokeMethod(this.settings, "getProjectPluginsDir", new Object[0]);
    }

    public void setProjectPluginsDir(File dir) {
        this.invokeMethod(this.settings, "setProjectPluginsDir", new Object[]{dir});
    }

    public File getGlobalPluginsDir() {
        return (File)this.invokeMethod(this.settings, "getGlobalPluginsDir", new Object[0]);
    }

    public void setGlobalPluginsDir(File dir) {
        this.invokeMethod(this.settings, "setGlobalPluginsDir", new Object[]{dir});
    }

    public File getTestReportsDir() {
        return (File)this.invokeMethod(this.settings, "getTestReportsDir", new Object[0]);
    }

    public void setTestReportsDir(File dir) {
        this.invokeMethod(this.settings, "setTestReportsDir", new Object[]{dir});
    }

    public List getCompileDependencies() {
        return (List)this.invokeMethod(this.settings, "getCompileDependencies", new Object[0]);
    }

    public void setCompileDependencies(List dependencies) {
        this.invokeMethod(this.settings, "setCompileDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    public List getTestDependencies() {
        return (List)this.invokeMethod(this.settings, "getTestDependencies", new Object[0]);
    }

    public void setTestDependencies(List dependencies) {
        this.invokeMethod(this.settings, "setTestDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    public List getRuntimeDependencies() {
        return (List)this.invokeMethod(this.settings, "getRuntimeDependencies", new Object[0]);
    }

    public void setRuntimeDependencies(List dependencies) {
        this.invokeMethod(this.settings, "setRuntimeDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    private Object createScriptRunner() throws Exception {
        return this.classLoader.loadClass("org.codehaus.groovy.grails.cli.GrailsScriptRunner").getDeclaredConstructor(this.settings.getClass()).newInstance(this.settings);
    }

    private Object invokeMethod(Object target, String name, Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return this.invokeMethod(target, name, argTypes, args);
    }

    private Object invokeMethod(Object target, String name, Class[] argTypes, Object[] args) {
        try {
            return target.getClass().getMethod(name, argTypes).invoke(target, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

