/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.model.ObjectFactory;
import org.gradlex.javamodule.moduleinfo.ModuleSpec;
import org.jspecify.annotations.Nullable;

public class ModuleInfo
extends ModuleSpec {
    private final @Nullable String moduleVersion;
    boolean openModule = true;
    final Map<String, Set<String>> exports = new LinkedHashMap<String, Set<String>>();
    final Map<String, Set<String>> opens = new LinkedHashMap<String, Set<String>>();
    final Set<String> requires = new LinkedHashSet<String>();
    final Set<String> requiresTransitive = new LinkedHashSet<String>();
    final Set<String> requiresStatic = new LinkedHashSet<String>();
    final Set<String> requiresStaticTransitive = new LinkedHashSet<String>();
    final Map<String, Set<String>> ignoreServiceProviders = new LinkedHashMap<String, Set<String>>();
    final Set<String> uses = new LinkedHashSet<String>();
    boolean exportAllPackages;
    boolean requireAllDefinedDependencies;
    boolean patchRealModule;
    boolean preserveExisting;

    ModuleInfo(String identifier, String moduleName, @Nullable String moduleVersion, ObjectFactory objectFactory) {
        super(identifier, moduleName);
        this.moduleVersion = moduleVersion;
    }

    public void closeModule() {
        this.openModule = false;
    }

    public void opens(String opens, String ... to) {
        this.closeModule();
        ModuleInfo.addOrThrow(this.opens, opens, to);
    }

    public void exports(String exports, String ... to) {
        ModuleInfo.addOrThrow(this.exports, exports, to);
    }

    public void requires(String requires) {
        ModuleInfo.addOrThrow(this.requires, requires);
    }

    public void requiresTransitive(String requiresTransitive) {
        ModuleInfo.addOrThrow(this.requiresTransitive, requiresTransitive);
    }

    public void requiresStatic(String requiresStatic) {
        ModuleInfo.addOrThrow(this.requiresStatic, requiresStatic);
    }

    public void requiresStaticTransitive(String requiresStaticTransitive) {
        ModuleInfo.addOrThrow(this.requiresStaticTransitive, requiresStaticTransitive);
    }

    public void uses(String uses) {
        ModuleInfo.addOrThrow(this.uses, uses);
    }

    public void ignoreServiceProvider(String provider, String ... implementations) {
        ModuleInfo.addOrThrow(this.ignoreServiceProviders, provider, implementations);
    }

    public @Nullable String getModuleVersion() {
        return this.moduleVersion;
    }

    public void exportAllPackages() {
        this.exportAllPackages = true;
    }

    public void requireAllDefinedDependencies() {
        this.requireAllDefinedDependencies = true;
    }

    public void patchRealModule() {
        this.patchRealModule = true;
    }

    public void preserveExisting() {
        this.patchRealModule = true;
        this.preserveExisting = true;
    }

    private static void addOrThrow(Set<String> target, String element) {
        if (!target.add(element)) {
            throw new IllegalArgumentException("The element '" + element + "' is already specified");
        }
    }

    private static void addOrThrow(Map<String, Set<String>> target, String key, String ... elements) {
        if (target.put(key, new LinkedHashSet<String>(Arrays.asList(elements))) != null) {
            throw new IllegalArgumentException("The element '" + key + "' is already specified");
        }
    }
}

