/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;
import org.gradlex.javamodule.moduleinfo.ExtraJavaModuleInfoPlugin;
import org.gradlex.javamodule.moduleinfo.ExtraJavaModuleInfoPluginExtension;

public class PublishedMetadata
implements Serializable {
    private static final Attribute<String> CATEGORY_ATTRIBUTE_UNTYPED = Attribute.of((String)Category.CATEGORY_ATTRIBUTE.getName(), String.class);
    private static final String DEFAULT_VERSION_SOURCE_CONFIGURATION = "definedDependenciesVersions";
    private final String gav;
    private final List<String> requires = new ArrayList<String>();
    private final List<String> requiresTransitive = new ArrayList<String>();
    private final List<String> requiresStaticTransitive = new ArrayList<String>();
    private String errorMessage = null;

    PublishedMetadata(String gav, Project project, ExtraJavaModuleInfoPluginExtension extension) {
        this.gav = gav;
        List<String> compileDependencies = this.componentVariant((Provider<String>)extension.getVersionsProvidingConfiguration(), project, "java-api");
        List<String> runtimeDependencies = this.componentVariant((Provider<String>)extension.getVersionsProvidingConfiguration(), project, "java-runtime");
        Stream.concat(compileDependencies.stream(), runtimeDependencies.stream()).distinct().forEach(ga -> {
            if (compileDependencies.contains(ga) && runtimeDependencies.contains(ga)) {
                this.requiresTransitive.add((String)ga);
            } else if (runtimeDependencies.contains(ga)) {
                this.requires.add((String)ga);
            } else if (compileDependencies.contains(ga)) {
                this.requiresStaticTransitive.add((String)ga);
            }
        });
    }

    private List<String> componentVariant(Provider<String> versionsProvidingConfiguration, Project project, String usage) {
        Configuration versionsSource = versionsProvidingConfiguration.isPresent() ? project.getConfigurations().getByName((String)versionsProvidingConfiguration.get()) : this.maybeCreateDefaultVersionSourcConfiguration(project.getConfigurations(), project.getObjects(), (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class));
        Configuration singleComponentVariantResolver = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)this.gav)});
        singleComponentVariantResolver.setCanBeConsumed(false);
        singleComponentVariantResolver.shouldResolveConsistentlyWith(versionsSource);
        versionsSource.getAttributes().keySet().forEach(a -> {
            Attribute untypedAttributeKey = a;
            singleComponentVariantResolver.getAttributes().attribute(untypedAttributeKey, Objects.requireNonNull(versionsSource.getAttributes().getAttribute(a)));
        });
        singleComponentVariantResolver.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, usage)));
        return this.firstAndOnlyComponentDependencies(singleComponentVariantResolver);
    }

    private Configuration maybeCreateDefaultVersionSourcConfiguration(ConfigurationContainer configurations, ObjectFactory objects, SourceSetContainer sourceSets) {
        String name = DEFAULT_VERSION_SOURCE_CONFIGURATION;
        Configuration existing = (Configuration)configurations.findByName(name);
        if (existing != null) {
            return existing;
        }
        return (Configuration)configurations.create(name, c -> {
            c.setCanBeResolved(true);
            c.setCanBeConsumed(false);
            c.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "java-runtime")));
            c.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "library")));
            c.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objects.named(LibraryElements.class, "jar")));
            c.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objects.named(Bundling.class, "external")));
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.0")) >= 0) {
                c.getAttributes().attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)((TargetJvmEnvironment)objects.named(TargetJvmEnvironment.class, "standard-jvm")));
            }
            if (sourceSets != null) {
                for (SourceSet sourceSet : sourceSets) {
                    Configuration implementation = configurations.getByName(sourceSet.getImplementationConfigurationName());
                    Configuration compileOnly = configurations.getByName(sourceSet.getCompileOnlyConfigurationName());
                    Configuration runtimeOnly = configurations.getByName(sourceSet.getRuntimeOnlyConfigurationName());
                    Configuration annotationProcessor = configurations.getByName(sourceSet.getAnnotationProcessorConfigurationName());
                    c.extendsFrom(new Configuration[]{implementation, compileOnly, runtimeOnly, annotationProcessor});
                }
            }
        });
    }

    private List<String> firstAndOnlyComponentDependencies(Configuration singleComponentVariantResolver) {
        DependencyResult result = (DependencyResult)singleComponentVariantResolver.getIncoming().getResolutionResult().getRoot().getDependencies().iterator().next();
        if (result instanceof UnresolvedDependencyResult) {
            this.errorMessage = ((UnresolvedDependencyResult)result).getFailure().getMessage();
            return Collections.emptyList();
        }
        return ((ResolvedDependencyResult)result).getSelected().getDependencies().stream().filter(PublishedMetadata::filterComponentDependencies).map(PublishedMetadata::ga).collect(Collectors.toList());
    }

    private static boolean filterComponentDependencies(DependencyResult d) {
        if (d instanceof ResolvedDependencyResult) {
            Category category = (Category)((ResolvedDependencyResult)d).getResolvedVariant().getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
            String categoryUntyped = (String)((ResolvedDependencyResult)d).getResolvedVariant().getAttributes().getAttribute(CATEGORY_ATTRIBUTE_UNTYPED);
            return "library".equals(categoryUntyped) || category != null && "library".equals(category.getName());
        }
        return false;
    }

    private static String ga(DependencyResult d) {
        if (d instanceof ResolvedDependencyResult) {
            return ExtraJavaModuleInfoPlugin.ga(((ResolvedDependencyResult)d).getSelected().getId());
        }
        return d.getRequested().getDisplayName();
    }

    public String getGav() {
        return this.gav;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public List<String> getRequiresTransitive() {
        return this.requiresTransitive;
    }

    public List<String> getRequiresStaticTransitive() {
        return this.requiresStaticTransitive;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

