/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import org.gradle.testretry.org.objectweb.asm.MethodVisitor;

final class SpockParameterClassVisitor
extends TestsReader.Visitor<Map<String, List<String>>> {
    private static final String SPOCK_PARAM_PATTERN = "#[\\p{L}\\d$_.()&&[^#\\s]]+";
    private static final String WILDCARD = ".*";
    private final Set<String> failedTestNames;
    private final TestsReader testsReader;
    private final Map<String, SpockParameterMethodVisitor> spockMethodVisitorByMethodName = new HashMap<String, SpockParameterMethodVisitor>();
    private boolean isSpec;

    public SpockParameterClassVisitor(Set<String> testMethodName, TestsReader testsReader) {
        this.failedTestNames = testMethodName;
        this.testsReader = testsReader;
    }

    @Override
    public Map<String, List<String>> getResult() {
        if (!this.isSpec) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.spockMethodVisitorByMethodName.values().stream().filter(SpockParameterMethodVisitor::isSpockTestMethod).forEach(spockMethodVisitor -> {
            Optional<String> unrollTemplate = spockMethodVisitor.getUnrollTemplate();
            if (unrollTemplate.isPresent()) {
                this.addMatchingMethodForFailedTests(map, unrollTemplate.get(), spockMethodVisitor.getTestMethodName());
            } else {
                this.addMatchingMethodForFailedTests(map, spockMethodVisitor.getTestMethodName(), spockMethodVisitor.getTestMethodName());
            }
        });
        return map;
    }

    private void addMatchingMethodForFailedTests(Map<String, List<String>> matchingMethodsPerFailedTest, String methodPattern, String methodName) {
        String methodPatternRegex = Arrays.stream(methodPattern.split(SPOCK_PARAM_PATTERN)).map(Pattern::quote).collect(Collectors.joining(WILDCARD)) + WILDCARD;
        this.failedTestNames.forEach(failedTestName -> {
            List matches = matchingMethodsPerFailedTest.computeIfAbsent((String)failedTestName, ignored -> new ArrayList());
            if (methodPattern.equals(failedTestName) || failedTestName.matches(methodPatternRegex)) {
                matches.add(methodName);
            }
        });
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (superName != null) {
            if (superName.equals("spock/lang/Specification")) {
                this.isSpec = true;
            } else if (!superName.equals("java/lang/Object")) {
                this.testsReader.readClass(superName.replace('/', '.'), () -> this);
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.isSpec ? (MethodVisitor)this.spockMethodVisitorByMethodName.computeIfAbsent(name, __ -> new SpockParameterMethodVisitor()) : null;
    }

    private static final class SpockParameterMethodVisitor
    extends MethodVisitor {
        @Nullable
        private SpockFeatureMetadataAnnotationVisitor featureMethodAnnotationVisitor;
        @Nullable
        private SpockUnrollAnnotationVisitor unrollAnnotationVisitor;

        public SpockParameterMethodVisitor() {
            super(458752);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.contains("org/spockframework/runtime/model/FeatureMetadata")) {
                this.featureMethodAnnotationVisitor = new SpockFeatureMetadataAnnotationVisitor();
                return this.featureMethodAnnotationVisitor;
            }
            if (descriptor.contains("spock/lang/Unroll")) {
                this.unrollAnnotationVisitor = new SpockUnrollAnnotationVisitor();
                return this.unrollAnnotationVisitor;
            }
            return null;
        }

        public boolean isSpockTestMethod() {
            return this.featureMethodAnnotationVisitor != null;
        }

        public String getTestMethodName() {
            return Objects.requireNonNull(Objects.requireNonNull(this.featureMethodAnnotationVisitor).testMethodName);
        }

        public Optional<String> getUnrollTemplate() {
            return Optional.ofNullable(this.unrollAnnotationVisitor).map(visitor -> ((SpockUnrollAnnotationVisitor)visitor).unrollTemplate);
        }

        private static final class SpockUnrollAnnotationVisitor
        extends AnnotationVisitor {
            private String unrollTemplate;

            public SpockUnrollAnnotationVisitor() {
                super(458752);
            }

            @Override
            public void visit(String name, Object value) {
                if ("value".equals(name)) {
                    this.unrollTemplate = (String)value;
                }
            }
        }

        private static final class SpockFeatureMetadataAnnotationVisitor
        extends AnnotationVisitor {
            private String testMethodName;

            public SpockFeatureMetadataAnnotationVisitor() {
                super(458752);
            }

            @Override
            public void visit(String name, Object value) {
                if ("name".equals(name)) {
                    this.testMethodName = (String)value;
                }
            }
        }
    }
}

