/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.twirl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.playframework.tools.internal.twirl.TwirlCompileSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultTwirlPostProcessor
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTwirlPostProcessor.class);
    private static final String GENERATED_TAG = "-- GENERATED --";
    private static final String GENERATED_LINE_PREFIX_DATE = "DATE: ";
    private static final String GENERATED_LINE_PREFIX_SOURCE = "SOURCE: ";

    DefaultTwirlPostProcessor() {
    }

    void execute(TwirlCompileSpec spec) {
        String sourceReplacementString = this.getSourceReplacementString(spec.getSources());
        try (Stream<Path> stream = Files.find(spec.getDestinationDir().toPath(), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
            stream.forEach(routeFile -> this.process((Path)routeFile, sourceReplacementString));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to post-process files", (Throwable)e);
        }
    }

    private String getSourceReplacementString(Iterable<RelativeFile> sources) {
        String sourceReplacementString = "";
        if (sources.iterator().hasNext()) {
            RelativeFile sourceFile = sources.iterator().next();
            sourceReplacementString = GENERATED_LINE_PREFIX_SOURCE + sourceFile.getRelativePath();
        }
        return sourceReplacementString;
    }

    private void process(Path generatedFile, String sourceReplacementString) {
        try {
            List<String> generatedSourceLines = Files.readAllLines(generatedFile, StandardCharsets.UTF_8);
            ArrayList<String> updatedSourceLines = new ArrayList<String>();
            boolean isInGeneratedSection = false;
            for (String currentLine : generatedSourceLines) {
                if (currentLine.contains(GENERATED_TAG)) {
                    boolean bl = isInGeneratedSection = !isInGeneratedSection;
                }
                if (isInGeneratedSection && currentLine.contains(GENERATED_LINE_PREFIX_SOURCE)) {
                    String updatedLine = currentLine.substring(0, currentLine.indexOf(GENERATED_LINE_PREFIX_SOURCE)) + sourceReplacementString;
                    updatedSourceLines.add(updatedLine);
                    continue;
                }
                if (isInGeneratedSection && currentLine.contains(GENERATED_LINE_PREFIX_DATE)) continue;
                updatedSourceLines.add(currentLine);
            }
            Files.write(generatedFile, updatedSourceLines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Unable to post-process file %s", generatedFile.getFileName()), (Throwable)e);
        }
    }
}

