/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.sourcesets.TwirlImports;
import org.gradle.playframework.sourcesets.TwirlTemplateFormat;
import org.gradle.playframework.tasks.internal.TwirlCompileParameters;
import org.gradle.playframework.tasks.internal.TwirlCompileWorkAction;
import org.gradle.playframework.tools.internal.Compiler;
import org.gradle.playframework.tools.internal.twirl.DefaultTwirlCompileSpec;
import org.gradle.playframework.tools.internal.twirl.TwirlCompileSpec;
import org.gradle.playframework.tools.internal.twirl.TwirlCompilerFactory;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public class TwirlCompile
extends SourceTask {
    private final WorkerExecutor workerExecutor;
    private final DirectoryProperty outputDirectory;
    private final Property<TwirlImports> defaultImports;
    private final Property<PlayPlatform> platform;
    private final ListProperty<TwirlTemplateFormat> userTemplateFormats;
    private final ListProperty<String> additionalImports;
    private final ConfigurableFileCollection twirlCompilerClasspath;
    private final ListProperty<String> constructorAnnotations;

    @Inject
    public TwirlCompile(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.outputDirectory = this.getProject().getObjects().directoryProperty();
        this.platform = this.getProject().getObjects().property(PlayPlatform.class);
        this.defaultImports = this.getProject().getObjects().property(TwirlImports.class);
        this.userTemplateFormats = this.getProject().getObjects().listProperty(TwirlTemplateFormat.class).empty();
        this.additionalImports = this.getProject().getObjects().listProperty(String.class);
        this.twirlCompilerClasspath = this.getProject().files(new Object[0]);
        this.constructorAnnotations = this.getProject().getObjects().listProperty(String.class).empty();
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Optional
    @Input
    public Property<TwirlImports> getDefaultImports() {
        return this.defaultImports;
    }

    @Classpath
    public ConfigurableFileCollection getTwirlCompilerClasspath() {
        return this.twirlCompilerClasspath;
    }

    @TaskAction
    void compile() {
        RelativeFileCollector relativeFileCollector = new RelativeFileCollector();
        this.getSource().visit((FileVisitor)relativeFileCollector);
        final DefaultTwirlCompileSpec spec = new DefaultTwirlCompileSpec(relativeFileCollector.relativeFiles, ((Directory)this.getOutputDirectory().get()).getAsFile(), (TwirlImports)((Object)this.getDefaultImports().get()), (Collection)this.userTemplateFormats.get(), (List)this.additionalImports.get(), (List)this.constructorAnnotations.get());
        WorkQueue workQueue = this.workerExecutor.processIsolation((Action)new Action<ProcessWorkerSpec>(){

            public void execute(ProcessWorkerSpec workerSpec) {
                workerSpec.forkOptions(options -> options.jvmArgs(new Object[]{"-XX:MaxMetaspaceSize=256m"}));
                workerSpec.getClasspath().from(new Object[]{TwirlCompile.this.twirlCompilerClasspath});
            }
        });
        workQueue.submit(TwirlCompileWorkAction.class, (Action)new Action<TwirlCompileParameters>(){

            public void execute(TwirlCompileParameters parameters) {
                parameters.getTwirlCompileSpec().set((Object)spec);
                parameters.getCompiler().set((Object)TwirlCompile.this.getCompiler());
            }
        });
    }

    private Compiler<TwirlCompileSpec> getCompiler() {
        return TwirlCompilerFactory.create((PlayPlatform)this.platform.get());
    }

    @Internal
    public Property<PlayPlatform> getPlatform() {
        return this.platform;
    }

    @Input
    public ListProperty<TwirlTemplateFormat> getUserTemplateFormats() {
        return this.userTemplateFormats;
    }

    @Input
    public ListProperty<String> getAdditionalImports() {
        return this.additionalImports;
    }

    @Input
    public ListProperty<String> getConstructorAnnotations() {
        return this.constructorAnnotations;
    }

    private static class RelativeFileCollector
    implements FileVisitor {
        List<RelativeFile> relativeFiles = new ArrayList<RelativeFile>();

        private RelativeFileCollector() {
        }

        public void visitDir(FileVisitDetails dirDetails) {
        }

        public void visitFile(FileVisitDetails fileDetails) {
            this.relativeFiles.add(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
        }
    }
}

