/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tasks.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.playframework.tools.internal.Compiler;
import org.gradle.playframework.tools.internal.routes.RoutesCompileSpec;

public class RoutesCompileRunnable
implements Runnable {
    private final RoutesCompileSpec routesCompileSpec;
    private final Compiler<RoutesCompileSpec> compiler;

    @Inject
    public RoutesCompileRunnable(RoutesCompileSpec routesCompileSpec, Compiler<RoutesCompileSpec> compiler) {
        this.routesCompileSpec = routesCompileSpec;
        this.compiler = compiler;
    }

    @Override
    public void run() {
        Path destinationPath = this.routesCompileSpec.getDestinationDir().toPath();
        this.deleteOutputs(destinationPath);
        this.compiler.execute(this.routesCompileSpec);
    }

    private void deleteOutputs(Path pathToBeDeleted) {
        try {
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).map(path -> path.toFile()).forEach(file -> file.delete());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

