/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tasks;

import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.tasks.internal.RoutesCompileParameters;
import org.gradle.playframework.tasks.internal.RoutesCompileWorkAction;
import org.gradle.playframework.tools.internal.Compiler;
import org.gradle.playframework.tools.internal.routes.DefaultRoutesCompileSpec;
import org.gradle.playframework.tools.internal.routes.RoutesCompileSpec;
import org.gradle.playframework.tools.internal.routes.RoutesCompilerFactory;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkerExecutor;

public class RoutesCompile
extends SourceTask {
    private final WorkerExecutor workerExecutor;
    private final DirectoryProperty outputDirectory;
    private final ListProperty<String> additionalImports;
    private final Property<Boolean> namespaceReverseRouter;
    private final Property<Boolean> generateReverseRoutes;
    private final Property<PlayPlatform> platform;
    private final Property<Boolean> injectedRoutesGenerator;
    private final ConfigurableFileCollection routesCompilerClasspath;
    private final File projectDir;

    @Inject
    public RoutesCompile(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.outputDirectory = this.getProject().getObjects().directoryProperty();
        this.additionalImports = this.getProject().getObjects().listProperty(String.class).empty();
        this.namespaceReverseRouter = this.getProject().getObjects().property(Boolean.class);
        this.namespaceReverseRouter.set((Object)false);
        this.generateReverseRoutes = this.getProject().getObjects().property(Boolean.class);
        this.generateReverseRoutes.set((Object)true);
        this.platform = this.getProject().getObjects().property(PlayPlatform.class);
        this.injectedRoutesGenerator = this.getProject().getObjects().property(Boolean.class);
        this.injectedRoutesGenerator.set((Object)false);
        this.routesCompilerClasspath = this.getProject().files(new Object[0]);
        this.projectDir = this.getProject().getProjectDir();
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public ListProperty<String> getAdditionalImports() {
        return this.additionalImports;
    }

    @Classpath
    public ConfigurableFileCollection getRoutesCompilerClasspath() {
        return this.routesCompilerClasspath;
    }

    @TaskAction
    void compile() {
        final DefaultRoutesCompileSpec spec = new DefaultRoutesCompileSpec(this.getSource().getFiles(), ((Directory)this.getOutputDirectory().get()).getAsFile(), this.isJavaProject(), (Boolean)this.getNamespaceReverseRouter().get(), (Boolean)this.getGenerateReverseRoutes().get(), (Boolean)this.getInjectedRoutesGenerator().get(), (Collection)this.getAdditionalImports().get(), this.projectDir);
        this.workerExecutor.processIsolation((Action)new Action<ProcessWorkerSpec>(){

            public void execute(ProcessWorkerSpec workerSpec) {
                workerSpec.forkOptions(options -> options.jvmArgs(new Object[]{"-XX:MaxMetaspaceSize=256m"}));
                workerSpec.getClasspath().from(new Object[]{RoutesCompile.this.routesCompilerClasspath});
            }
        }).submit(RoutesCompileWorkAction.class, (Action)new Action<RoutesCompileParameters>(){

            public void execute(RoutesCompileParameters parameters) {
                parameters.getCompiler().set((Object)RoutesCompile.this.getCompiler());
                parameters.getSpec().set((Object)spec);
            }
        });
    }

    private Compiler<RoutesCompileSpec> getCompiler() {
        return RoutesCompilerFactory.create((PlayPlatform)this.getPlatform().get());
    }

    @Internal
    public boolean isJavaProject() {
        return false;
    }

    @Internal
    public Property<PlayPlatform> getPlatform() {
        return this.platform;
    }

    @Input
    public Property<Boolean> getNamespaceReverseRouter() {
        return this.namespaceReverseRouter;
    }

    @Input
    public Property<Boolean> getGenerateReverseRoutes() {
        return this.generateReverseRoutes;
    }

    @Input
    public Property<Boolean> getInjectedRoutesGenerator() {
        return this.injectedRoutesGenerator;
    }
}

