/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.extensions;

import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.extensions.internal.PlayMajorVersion;

public class PlayExtension {
    private final PlayPlatform platform;
    private final Property<Boolean> injectedRoutesGenerator;

    public PlayExtension(ObjectFactory objectFactory) {
        this.platform = (PlayPlatform)objectFactory.newInstance(PlayPlatform.class, new Object[]{objectFactory});
        this.platform.getPlayVersion().convention((Object)"2.6.25");
        this.platform.getJavaVersion().convention((Object)JavaVersion.current());
        this.platform.getScalaVersion().convention(this.platform.getPlayVersion().map(playVersion -> PlayMajorVersion.forPlayVersion(playVersion).getDefaultScalaPlatform()));
        this.injectedRoutesGenerator = objectFactory.property(Boolean.class);
        this.injectedRoutesGenerator.convention(this.platform.getPlayVersion().map(playVersion -> !PlayMajorVersion.forPlayVersion(playVersion).hasSupportForStaticRoutesGenerator()));
    }

    public void platform(Action<? super PlayPlatform> action) {
        action.execute((Object)this.platform);
    }

    public PlayPlatform getPlatform() {
        return this.platform;
    }

    public Property<Boolean> getInjectedRoutesGenerator() {
        return this.injectedRoutesGenerator;
    }
}

