/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.run;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URLClassLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.playframework.tools.internal.run.PlayAppLifecycleUpdate;
import org.gradle.playframework.tools.internal.run.PlayRunSpec;
import org.gradle.playframework.tools.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.playframework.tools.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.playframework.tools.internal.run.Reloader;
import org.gradle.playframework.tools.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayWorkerServer
implements Action<WorkerProcessContext>,
PlayRunWorkerServerProtocol,
Reloader,
Serializable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayWorkerServer.class);
    private final PlayRunSpec runSpec;
    private final VersionedPlayRunAdapter runAdapter;
    private final Lock lock = new ReentrantLock();
    private final Condition signal = this.lock.newCondition();
    private final BlockingQueue<PlayAppLifecycleUpdate> events = new SynchronousQueue<PlayAppLifecycleUpdate>();
    private boolean stopRequested;
    private boolean serverStarted;
    private Reloader.Result latestStatus;

    public PlayWorkerServer(PlayRunSpec runSpec, VersionedPlayRunAdapter runAdapter) {
        this.runSpec = runSpec;
        this.runAdapter = runAdapter;
    }

    public void execute(WorkerProcessContext context) {
        PlayRunWorkerClientProtocol clientProtocol = (PlayRunWorkerClientProtocol)context.getServerConnection().addOutgoing(PlayRunWorkerClientProtocol.class);
        context.getServerConnection().addIncoming(PlayRunWorkerServerProtocol.class, (Object)this);
        context.getServerConnection().connect();
        PlayAppLifecycleUpdate result = this.start();
        this.serverStarted = true;
        try {
            clientProtocol.update(result);
            while (!this.stopRequested) {
                PlayAppLifecycleUpdate update = this.events.take();
                clientProtocol.update(update);
            }
            LOGGER.debug("Play App stopping");
            this.events.clear();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private PlayAppLifecycleUpdate start() {
        try {
            InetSocketAddress address = this.startServer();
            return PlayAppLifecycleUpdate.running(address);
        }
        catch (Exception e) {
            LOGGER.error("Failed to run Play", (Throwable)e);
            return PlayAppLifecycleUpdate.failed(e);
        }
    }

    private InetSocketAddress startServer() {
        ClassLoaderUtils.disableUrlConnectionCaching();
        Thread thread = Thread.currentThread();
        ClassLoader previousContextClassLoader = thread.getContextClassLoader();
        URLClassLoader classLoader = new URLClassLoader(DefaultClassPath.of(this.runSpec.getClasspath()).getAsURLArray(), ClassLoader.getSystemClassLoader());
        thread.setContextClassLoader(classLoader);
        try {
            Object buildDocHandler = this.runAdapter.getBuildDocHandler(classLoader, this.runSpec.getClasspath());
            Object buildLink = this.runAdapter.getBuildLink(classLoader, this, this.runSpec.getProjectPath(), this.runSpec.getApplicationJar(), this.runSpec.getChangingClasspath(), this.runSpec.getAssetsJar(), this.runSpec.getAssetsDirs());
            InetSocketAddress inetSocketAddress = this.runAdapter.runDevHttpServer(classLoader, classLoader, buildLink, buildDocHandler, this.runSpec.getHttpPort());
            return inetSocketAddress;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            thread.setContextClassLoader(previousContextClassLoader);
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            this.stopRequested = true;
            this.events.put(PlayAppLifecycleUpdate.stopped());
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void currentStatus(Boolean hasChanged, Throwable throwable) {
        this.lock.lock();
        try {
            this.latestStatus = new Reloader.Result(hasChanged, throwable);
            LOGGER.debug("notify currentStatus");
            this.signal.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Reloader.Result requireUpToDate() throws InterruptedException {
        this.lock.lock();
        try {
            if (!this.serverStarted) {
                Reloader.Result result = new Reloader.Result(true, null);
                return result;
            }
            if (!this.stopRequested) {
                LOGGER.debug("requireUpToDate");
                this.events.put(PlayAppLifecycleUpdate.reloadRequested());
                LOGGER.debug("waiting for block to clear");
                Reloader.Result oldStatus = this.latestStatus;
                while (this.latestStatus == oldStatus && !this.stopRequested) {
                    this.signal.await();
                }
                LOGGER.debug("block cleared {}", (Object)this.latestStatus);
                Reloader.Result result = this.latestStatus;
                return result;
            }
        }
        finally {
            this.lock.unlock();
        }
        return new Reloader.Result(false, null);
    }
}

