/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.twirl;

import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.extensions.internal.PlayMajorVersion;
import org.gradle.playframework.tools.internal.twirl.PlayTwirlAdapterV23X;
import org.gradle.playframework.tools.internal.twirl.PlayTwirlAdapterV26X;
import org.gradle.playframework.tools.internal.twirl.PlayTwirlAdapterV28X;
import org.gradle.playframework.tools.internal.twirl.TwirlCompiler;
import org.gradle.playframework.tools.internal.twirl.TwirlCompilerAdapterV10X;
import org.gradle.playframework.tools.internal.twirl.TwirlCompilerAdapterV13X;
import org.gradle.playframework.tools.internal.twirl.VersionedPlayTwirlAdapter;
import org.gradle.playframework.tools.internal.twirl.VersionedTwirlCompilerAdapter;

public class TwirlCompilerFactory {
    public static TwirlCompiler create(PlayPlatform playPlatform) {
        return new TwirlCompiler(TwirlCompilerFactory.createAdapter(playPlatform));
    }

    public static VersionedTwirlCompilerAdapter createAdapter(PlayPlatform playPlatform) {
        String scalaCompatibilityVersion = (String)playPlatform.getScalaCompatibilityVersion().get();
        VersionedPlayTwirlAdapter playTwirlAdapter = TwirlCompilerFactory.createPlayTwirlAdapter(playPlatform);
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: {
                return new TwirlCompilerAdapterV10X("1.0.4", scalaCompatibilityVersion, playTwirlAdapter);
            }
            case PLAY_2_4_X: 
            case PLAY_2_5_X: {
                return new TwirlCompilerAdapterV10X("1.1.1", scalaCompatibilityVersion, playTwirlAdapter);
            }
            case PLAY_2_6_X: {
                return new TwirlCompilerAdapterV13X("1.3.13", scalaCompatibilityVersion, playTwirlAdapter);
            }
        }
        return new TwirlCompilerAdapterV13X("1.5.1", scalaCompatibilityVersion, playTwirlAdapter);
    }

    public static VersionedPlayTwirlAdapter createPlayTwirlAdapter(PlayPlatform playPlatform) {
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: 
            case PLAY_2_4_X: 
            case PLAY_2_5_X: {
                return new PlayTwirlAdapterV23X();
            }
            case PLAY_2_6_X: 
            case PLAY_2_7_X: {
                return new PlayTwirlAdapterV26X();
            }
        }
        return new PlayTwirlAdapterV28X();
    }
}

