/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.sourcesets.internal;

import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.playframework.sourcesets.TwirlImports;
import org.gradle.playframework.sourcesets.TwirlSourceSet;
import org.gradle.playframework.sourcesets.TwirlTemplateFormat;
import org.gradle.playframework.sourcesets.internal.DefaultTwirlTemplateFormat;

public class DefaultTwirlSourceSet
implements TwirlSourceSet {
    private final SourceDirectorySet twirl;
    private final Property<TwirlImports> defaultImports;
    private final ListProperty<TwirlTemplateFormat> userTemplateFormats;
    private final ListProperty<String> additionalImports;
    private final ListProperty<String> constructorAnnotations;

    @Inject
    public DefaultTwirlSourceSet(String name, String displayName, ObjectFactory objectFactory) {
        this.twirl = objectFactory.sourceDirectorySet(name, displayName + " Twirl source");
        this.twirl.srcDirs(new Object[]{"app"});
        this.twirl.include(new String[]{"**/*.scala.*"});
        this.defaultImports = objectFactory.property(TwirlImports.class);
        this.defaultImports.set((Object)TwirlImports.SCALA);
        this.userTemplateFormats = objectFactory.listProperty(TwirlTemplateFormat.class).empty();
        this.additionalImports = objectFactory.listProperty(String.class).empty();
        this.constructorAnnotations = objectFactory.listProperty(String.class).empty();
    }

    @Override
    public SourceDirectorySet getTwirl() {
        return this.twirl;
    }

    @Override
    public TwirlSourceSet twirl(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getTwirl());
        return this;
    }

    @Override
    public Property<TwirlImports> getDefaultImports() {
        return this.defaultImports;
    }

    @Override
    public ListProperty<TwirlTemplateFormat> getUserTemplateFormats() {
        return this.userTemplateFormats;
    }

    @Override
    public TwirlTemplateFormat newUserTemplateFormat(String extension, String templateType, String ... imports) {
        return new DefaultTwirlTemplateFormat(extension, templateType, Arrays.asList(imports));
    }

    @Override
    public ListProperty<String> getAdditionalImports() {
        return this.additionalImports;
    }

    @Override
    public ListProperty<String> getConstructorAnnotations() {
        return this.constructorAnnotations;
    }
}

