/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins.internal;

import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;

public final class PlayPluginHelper {
    private PlayPluginHelper() {
    }

    public static SourceSet getMainJavaSourceSet(Project project) {
        return PlayPluginHelper.getSourceSet(project, "main");
    }

    public static SourceSet getTestJavaSourceSet(Project project) {
        return PlayPluginHelper.getSourceSet(project, "test");
    }

    private static SourceSet getSourceSet(Project project, String testSourceSetName) {
        JavaPluginExtension javaConvention = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return (SourceSet)javaConvention.getSourceSets().getByName(testSourceSetName);
    }

    public static SourceDirectorySet getMainScalaSourceDirectorySet(Project project) {
        return PlayPluginHelper.getScalaSourceDirectorySet(PlayPluginHelper.getMainJavaSourceSet(project));
    }

    public static SourceDirectorySet getTestScalaSourceDirectorySet(Project project) {
        return PlayPluginHelper.getScalaSourceDirectorySet(PlayPluginHelper.getTestJavaSourceSet(project));
    }

    private static SourceDirectorySet getScalaSourceDirectorySet(SourceSet sourceSet) {
        return (SourceDirectorySet)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getScala", null);
    }

    public static <T> T createCustomSourceSet(Project project, Class<? extends T> t, String name) {
        SourceSet mainSourceSet = PlayPluginHelper.getMainJavaSourceSet(project);
        Object customSourceSet = project.getObjects().newInstance(t, new Object[]{name, ((DefaultSourceSet)mainSourceSet).getDisplayName(), project.getObjects()});
        new DslObject((Object)mainSourceSet).getConvention().getPlugins().put(name, customSourceSet);
        return (T)customSourceSet;
    }
}

