/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.gradle.playframework.tools.internal.reflection.JavaMethod;
import org.gradle.playframework.tools.internal.reflection.NoSuchPropertyException;
import org.gradle.playframework.tools.internal.reflection.PropertyAccessor;
import org.gradle.playframework.tools.internal.reflection.ReflectionCache;

public final class JavaReflectionUtil {
    private JavaReflectionUtil() {
    }

    public static <T, R> JavaMethod<T, R> method(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        return new JavaMethod<T, R>(target, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> method(T target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.method(targetClass, returnType, name, paramTypes);
    }

    public static <T, F> PropertyAccessor<T, F> readableField(Class<T> target, Class<F> fieldType, String fieldName) {
        Field field = JavaReflectionUtil.findField(target, fieldName);
        if (field == null) {
            throw new NoSuchPropertyException(String.format("Could not find field '%s' on class %s.", fieldName, target.getSimpleName()));
        }
        return new FieldBackedPropertyAccessor(fieldName, fieldType, field);
    }

    public static <T, F> PropertyAccessor<T, F> readableField(T target, Class<F> fieldType, String fieldName) {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.readableField(targetClass, fieldType, fieldName);
    }

    public static <T, R> JavaMethod<T, R> staticMethod(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        return new JavaMethod<T, R>(target, returnType, name, true, paramTypes);
    }

    public static Class<?> getWrapperTypeForPrimitiveType(Class<?> type) {
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(String.format("Don't know the wrapper type for primitive type %s.", type));
    }

    public static <T> T newInstance(Class<T> c) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Field findField(Class<?> target, String fieldName) {
        Field[] fields;
        for (Field field : fields = target.getFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static class CachedConstructor
    extends ReflectionCache.CachedInvokable<Constructor<?>> {
        public CachedConstructor(Constructor<?> ctor) {
            super(ctor);
        }
    }

    private static class FieldBackedPropertyAccessor<T, F>
    implements PropertyAccessor<T, F> {
        private final String property;
        private final Field field;
        private final Class<F> fieldType;

        FieldBackedPropertyAccessor(String property, Class<F> fieldType, Field field) {
            this.property = property;
            this.field = field;
            this.fieldType = fieldType;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<F> getType() {
            return this.fieldType;
        }

        @Override
        public F getValue(T target) {
            try {
                return this.fieldType.cast(this.field.get(target));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

