/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import groovy.util.Node;
import groovy.util.NodeList;
import groovy.xml.QName;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.DefaultScalaPlatform;
import org.gradle.playframework.extensions.PlayExtension;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.plugins.internal.PlayPluginHelper;
import org.gradle.playframework.tasks.JavaScriptMinify;
import org.gradle.playframework.tasks.RoutesCompile;
import org.gradle.playframework.tasks.TwirlCompile;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;

public class PlayIdeaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().named("ideaModule", GenerateIdeaModule.class, ideaModuleTask -> {
            IdeaModule module = ideaModuleTask.getModule();
            ConventionMapping conventionMapping = this.conventionMappingFor(module);
            TaskProvider javaScriptMinifyTask = project.getTasks().named("minifyPlayJavaScript", JavaScriptMinify.class);
            TaskProvider routesCompileTask = project.getTasks().named("compilePlayRoutes", RoutesCompile.class);
            TaskProvider twirlCompileTask = project.getTasks().named("compilePlayTwirlTemplates", TwirlCompile.class);
            conventionMapping.map("sourceDirs", () -> {
                HashSet<File> sourceDirs = new HashSet<File>();
                sourceDirs.add(new File(project.getProjectDir(), "public"));
                SourceDirectorySet scalaSourceDirectorySet = PlayPluginHelper.getMainScalaSourceDirectorySet(project);
                sourceDirs.addAll(scalaSourceDirectorySet.getSrcDirs());
                sourceDirs.add(((Directory)((JavaScriptMinify)((Object)((Object)((Object)javaScriptMinifyTask.get())))).getDestinationDir().get()).getAsFile());
                return sourceDirs;
            });
            conventionMapping.map("singleEntryLibraries", () -> {
                SourceSet mainSourceSet = PlayPluginHelper.getMainJavaSourceSet(project);
                SourceSet testSourceSet = PlayPluginHelper.getTestJavaSourceSet(project);
                HashMap<String, Object> libs = new HashMap<String, Object>();
                libs.put("COMPILE", mainSourceSet.getOutput().getClassesDirs());
                libs.put("RUNTIME", Collections.singleton(mainSourceSet.getOutput().getResourcesDir()));
                libs.put("TEST", testSourceSet.getOutput().getClassesDirs());
                return Collections.unmodifiableMap(libs);
            });
            PlayExtension playExtension = (PlayExtension)project.getExtensions().getByName("play");
            module.setScalaPlatform((ScalaPlatform)new DefaultScalaPlatform((String)playExtension.getPlatform().getScalaVersion().get()));
            conventionMapping.map("targetBytecodeVersion", () -> this.getTargetJavaVersion(playExtension.getPlatform()));
            conventionMapping.map("languageLevel", () -> new IdeaLanguageLevel((Object)this.getTargetJavaVersion(playExtension.getPlatform())));
            module.getIml().withXml(xml -> {
                NodeList sourceFolders = xml.asNode().getAt(QName.valueOf((String)"component")).getAt(QName.valueOf((String)"content")).getAt(QName.valueOf((String)"sourceFolder"));
                sourceFolders.forEach(sourceFolder -> {
                    Node node = (Node)sourceFolder;
                    if (node.get("@url").equals("file://$MODULE_DIR$/conf")) {
                        node.attributes().put("type", "java-resource");
                    }
                });
            });
            ideaModuleTask.dependsOn(new Object[]{javaScriptMinifyTask});
            ideaModuleTask.dependsOn(new Object[]{routesCompileTask});
            ideaModuleTask.dependsOn(new Object[]{twirlCompileTask});
        });
    }

    private ConventionMapping conventionMappingFor(IdeaModule module) {
        return new DslObject((Object)module).getConventionMapping();
    }

    private JavaVersion getTargetJavaVersion(PlayPlatform Platform) {
        return (JavaVersion)Platform.getJavaVersion().get();
    }
}

