/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import java.util.Arrays;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.playframework.extensions.PlayExtension;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.extensions.internal.PlayMajorVersion;
import org.gradle.playframework.plugins.PlayRoutesPlugin;
import org.gradle.playframework.plugins.PlayTwirlPlugin;
import org.gradle.playframework.plugins.internal.PlayPluginHelper;
import org.gradle.playframework.tasks.PlayRun;
import org.gradle.playframework.tasks.RoutesCompile;
import org.gradle.playframework.tasks.TwirlCompile;
import org.gradle.util.VersionNumber;

public class PlayApplicationPlugin
implements Plugin<Project> {
    static final String PLAY_EXTENSION_NAME = "play";
    static final String PLATFORM_CONFIGURATION = "play";
    public static final String ASSETS_JAR_TASK_NAME = "createPlayAssetsJar";

    public void apply(Project project) {
        project.getPluginManager().apply(ScalaPlugin.class);
        PlayExtension playExtension = (PlayExtension)project.getExtensions().create("play", PlayExtension.class, new Object[]{project.getObjects()});
        Configuration playConfiguration = (Configuration)project.getConfigurations().create("play");
        project.getConfigurations().getByName("compileClasspath").extendsFrom(new Configuration[]{playConfiguration});
        this.applyPlayPlugins(project);
        this.configureJavaAndScalaSourceSet(project);
        TaskProvider mainJarTask = project.getTasks().named("jar", Jar.class);
        TaskProvider<Jar> assetsJarTask = this.createAssetsJarTask(project);
        this.registerOutgoingArtifact(project, assetsJarTask);
        TaskProvider<PlayRun> playRun = this.createRunTask(project, playExtension, (TaskProvider<Jar>)mainJarTask, assetsJarTask);
        project.afterEvaluate(project1 -> {
            PlayPlatform playPlatform = playExtension.getPlatform();
            this.failIfInjectedRouterIsUsedWithOldVersion((Boolean)playExtension.getInjectedRoutesGenerator().get(), playPlatform);
            this.addAutomaticDependencies(project.getDependencies(), playPlatform);
            this.configureRunTask(playRun, this.filtered(project.getConfigurations().getByName("runtimeClasspath")));
        });
    }

    private void applyPlayPlugins(Project project) {
        project.getPluginManager().apply(PlayTwirlPlugin.class);
        project.getPluginManager().apply(PlayRoutesPlugin.class);
    }

    private void failIfInjectedRouterIsUsedWithOldVersion(Boolean injectedRoutesGenerator, PlayPlatform playPlatform) {
        if (Boolean.TRUE.equals(injectedRoutesGenerator)) {
            VersionNumber minSupportedVersion = VersionNumber.parse((String)"2.4.0");
            VersionNumber playVersion = VersionNumber.parse((String)((String)playPlatform.getPlayVersion().get()));
            if (playVersion.compareTo(minSupportedVersion) < 0) {
                throw new GradleException("Injected routers are only supported in Play 2.4 or newer.");
            }
        }
    }

    private void addAutomaticDependencies(DependencyHandler dependencies, PlayPlatform playPlatform) {
        dependencies.add("play", playPlatform.getDependencyNotation("play").get());
        dependencies.add("testImplementation", playPlatform.getDependencyNotation("play-test").get());
        dependencies.add("runtimeOnly", playPlatform.getDependencyNotation("play-docs").get());
        PlayMajorVersion playMajorVersion = PlayMajorVersion.forPlatform(playPlatform);
        switch (playMajorVersion) {
            case PLAY_2_6_X: 
            case PLAY_2_7_X: {
                dependencies.add("play", playPlatform.getDependencyNotation("play-java-forms").get());
            }
        }
    }

    private void configureJavaAndScalaSourceSet(Project project) {
        SourceSet mainSourceSet = PlayPluginHelper.getMainJavaSourceSet(project);
        SourceDirectorySet mainResourcesDirectorySet = mainSourceSet.getResources();
        mainResourcesDirectorySet.setSrcDirs(Arrays.asList("conf"));
        SourceDirectorySet mainScalaSourceDirectorySet = PlayPluginHelper.getMainScalaSourceDirectorySet(project);
        mainScalaSourceDirectorySet.setSrcDirs(Arrays.asList("app"));
        mainScalaSourceDirectorySet.include(new String[]{"**/*.scala", "**/*.java"});
        mainScalaSourceDirectorySet.srcDir((Object)PlayApplicationPlugin.getTwirlCompileTask(project).flatMap(task -> task.getOutputDirectory()));
        mainScalaSourceDirectorySet.srcDir((Object)PlayApplicationPlugin.getRoutesCompileTask(project).flatMap(task -> task.getOutputDirectory()));
        SourceDirectorySet testScalaSourceDirectorySet = PlayPluginHelper.getTestScalaSourceDirectorySet(project);
        testScalaSourceDirectorySet.setSrcDirs(Arrays.asList("test"));
        testScalaSourceDirectorySet.include(new String[]{"**/*.scala", "**/*.java"});
    }

    private TaskProvider<Jar> createAssetsJarTask(Project project) {
        TaskProvider assetsJarTask = project.getTasks().register(ASSETS_JAR_TASK_NAME, Jar.class, jar -> {
            jar.setDescription("Assembles the assets jar for the application.");
            jar.getArchiveClassifier().set((Object)"assets");
            jar.from((Object)project.file((Object)"public"), copySpec -> copySpec.into((Object)"public"));
        });
        project.getTasks().named("assemble", assembleTask -> assembleTask.dependsOn(new Object[]{assetsJarTask}));
        return assetsJarTask;
    }

    private void registerOutgoingArtifact(Project project, TaskProvider<Jar> assetsJarTask) {
        Configuration runtimeElementsConfiguration = project.getConfigurations().getByName("runtimeElements");
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(assetsJarTask);
        ConfigurationPublications publications = runtimeElementsConfiguration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
    }

    private static TaskProvider<TwirlCompile> getTwirlCompileTask(Project project) {
        return project.getTasks().named("compilePlayTwirlTemplates", TwirlCompile.class);
    }

    private static TaskProvider<RoutesCompile> getRoutesCompileTask(Project project) {
        return project.getTasks().named("compilePlayRoutes", RoutesCompile.class);
    }

    private TaskProvider<PlayRun> createRunTask(Project project, PlayExtension playExtension, TaskProvider<Jar> mainJarTask, TaskProvider<Jar> assetsJarTask) {
        return project.getTasks().register("runPlay", PlayRun.class, playRun -> {
            playRun.setDescription("Runs the Play application for local development.");
            playRun.setGroup("Run");
            playRun.getWorkingDir().convention(project.getLayout().getProjectDirectory());
            playRun.getPlatform().convention(project.provider(() -> playExtension.getPlatform()));
            playRun.getApplicationJar().convention(((Jar)mainJarTask.get()).getArchiveFile());
            playRun.getAssetsJar().convention(((Jar)assetsJarTask.get()).getArchiveFile());
            playRun.getAssetsDirs().from(new Object[]{project.file((Object)"public")});
        });
    }

    private void configureRunTask(TaskProvider<PlayRun> playRun, PlayConfiguration filteredRuntime) {
        playRun.configure(task -> {
            task.getRuntimeClasspath().from(new Object[]{filteredRuntime.getNonChangingArtifacts()});
            task.getChangingClasspath().from(new Object[]{filteredRuntime.getChangingArtifacts()});
        });
    }

    PlayConfiguration filtered(Configuration configuration) {
        return new PlayConfiguration(configuration);
    }

    class PlayConfiguration {
        private final Configuration configuration;

        PlayConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        private boolean isChangingArtifact(ComponentIdentifier componentIdentifier) {
            return componentIdentifier instanceof ProjectComponentIdentifier;
        }

        FileCollection getChangingArtifacts() {
            return this.configuration.getIncoming().artifactView(view -> view.componentFilter(this::isChangingArtifact)).getFiles();
        }

        FileCollection getNonChangingArtifacts() {
            return this.configuration.getIncoming().artifactView(view -> view.componentFilter(componentId -> !this.isChangingArtifact((ComponentIdentifier)componentId))).getFiles();
        }
    }
}

