/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.twirl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.playframework.sourcesets.TwirlImports;
import org.gradle.playframework.sourcesets.TwirlTemplateFormat;
import org.gradle.playframework.tools.internal.scala.ScalaCodecMapper;
import org.gradle.playframework.tools.internal.scala.ScalaMethod;
import org.gradle.playframework.tools.internal.scala.ScalaReflectionUtil;
import org.gradle.playframework.tools.internal.scala.ScalaSeq;
import org.gradle.playframework.tools.internal.twirl.TwirlCompilerAdapterV10X;
import org.gradle.playframework.tools.internal.twirl.VersionedPlayTwirlAdapter;
import org.gradle.util.CollectionUtils;
import org.gradle.util.VersionNumber;

class TwirlCompilerAdapterV13X
extends TwirlCompilerAdapterV10X {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("play.twirl.compiler", "scala.io", "scala.util.parsing.input", "scala.collection");
    private static final List<String> DEFAULT_TEMPLATE_IMPORTS = Collections.unmodifiableList(Arrays.asList("_root_.play.twirl.api.TwirlFeatureImports._", "_root_.play.twirl.api.TwirlHelperImports._", "_root_.play.twirl.api.Html", "_root_.play.twirl.api.JavaScript", "_root_.play.twirl.api.Txt", "_root_.play.twirl.api.Xml"));

    public TwirlCompilerAdapterV13X(String twirlVersion, String scalaVersion, VersionedPlayTwirlAdapter playTwirlAdapter) {
        super(twirlVersion, scalaVersion, playTwirlAdapter);
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.twirl.compiler.TwirlCompiler", "compile", File.class, File.class, File.class, String.class, cl.loadClass("scala.collection.Seq"), cl.loadClass("scala.collection.Seq"), cl.loadClass(ScalaCodecMapper.getClassName()), Boolean.TYPE);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File sourceDirectory, File destinationDirectory, TwirlImports defaultPlayImports, TwirlTemplateFormat templateFormat, List<String> additionalImports, List<String> constructorAnnotations) {
        ArrayList<String> defaultImports = new ArrayList<String>(DEFAULT_TEMPLATE_IMPORTS);
        defaultImports.addAll(this.playTwirlAdapter.getDefaultImports(defaultPlayImports));
        return new Object[]{file, sourceDirectory, destinationDirectory, templateFormat.getFormatType(), this.toScalaSeq(CollectionUtils.flattenCollections((Object[])new Object[]{defaultImports, additionalImports, templateFormat.getTemplateImports()}), cl), this.toScalaSeq(constructorAnnotations, cl), ScalaCodecMapper.create(cl, "UTF-8"), this.isInclusiveDots()};
    }

    private Object toScalaSeq(Collection<?> list, ClassLoader classLoader) {
        return ScalaSeq.fromList(classLoader, list);
    }

    @Override
    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    @Override
    public List<String> getDependencyNotation() {
        VersionNumber scalaAsVersion = VersionNumber.parse((String)this.scalaVersion);
        if (scalaAsVersion.compareTo(VersionNumber.parse((String)"2.12")) >= 0) {
            return CollectionUtils.flattenCollections((Object[])new Object[]{super.getDependencyNotation(), "org.scala-lang.modules:scala-parser-combinators_" + this.scalaVersion + ":1.1.2"});
        }
        return super.getDependencyNotation();
    }
}

