/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.run;

import java.net.InetSocketAddress;
import javax.inject.Inject;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.playframework.tools.internal.run.PlayApplication;
import org.gradle.playframework.tools.internal.run.PlayApplicationRunner;
import org.gradle.playframework.tools.internal.run.PlayRunSpec;

public class PlayApplicationDeploymentHandle
implements DeploymentHandle {
    private final PlayRunSpec spec;
    private final PlayApplicationRunner playApplicationRunner;
    private PlayApplication playApplication;

    @Inject
    public PlayApplicationDeploymentHandle(PlayRunSpec spec, PlayApplicationRunner playApplicationRunner) {
        this.spec = spec;
        this.playApplicationRunner = playApplicationRunner;
    }

    public boolean isRunning() {
        return this.playApplication != null && this.playApplication.isRunning();
    }

    public void start(Deployment deployment) {
        this.playApplication = this.playApplicationRunner.start(this.spec, deployment);
    }

    public InetSocketAddress getPlayAppAddress() {
        if (this.isRunning()) {
            return this.playApplication.getPlayAppAddress();
        }
        return null;
    }

    public void stop() {
        this.playApplication.stop();
    }
}

