/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.run;

import java.net.InetSocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.deployment.internal.Deployment;
import org.gradle.internal.UncheckedException;
import org.gradle.playframework.tools.internal.run.PlayAppLifecycleUpdate;
import org.gradle.playframework.tools.internal.run.PlayAppReload;
import org.gradle.playframework.tools.internal.run.PlayAppStart;
import org.gradle.playframework.tools.internal.run.PlayAppStop;
import org.gradle.playframework.tools.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.playframework.tools.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.process.internal.worker.WorkerProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayApplication
implements PlayRunWorkerClientProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayApplication.class);
    private final PlayRunWorkerServerProtocol workerServer;
    private final WorkerProcess process;
    private final AtomicBoolean stopped;
    private final BlockingQueue<PlayAppStart> startEvent = new SynchronousQueue<PlayAppStart>();
    private final BlockingQueue<PlayAppStop> stopEvent = new SynchronousQueue<PlayAppStop>();
    private final Deployment activity;
    private InetSocketAddress playAppAddress;

    public PlayApplication(Deployment activity, PlayRunWorkerServerProtocol workerServer, WorkerProcess process) {
        this.workerServer = workerServer;
        this.process = process;
        this.stopped = new AtomicBoolean(false);
        this.activity = activity;
    }

    public boolean isRunning() {
        return !this.stopped.get();
    }

    public InetSocketAddress getPlayAppAddress() {
        return this.playAppAddress;
    }

    public void stop() {
        this.workerServer.stop();
        this.waitForEvent(this.stopEvent);
        this.process.waitForStop();
        this.stopped.set(true);
    }

    @Override
    public void update(PlayAppLifecycleUpdate update) {
        block5: {
            try {
                LOGGER.debug("Update from Play App {}", (Object)update);
                if (update instanceof PlayAppStart) {
                    this.startEvent.put((PlayAppStart)update);
                    break block5;
                }
                if (update instanceof PlayAppStop) {
                    this.stopEvent.put((PlayAppStop)update);
                    break block5;
                }
                if (update instanceof PlayAppReload) {
                    Deployment.Status status = this.activity.status();
                    this.workerServer.currentStatus(status.hasChanged(), status.getFailure());
                    break block5;
                }
                throw new IllegalStateException("Unexpected event " + update);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    public void waitForRunning() {
        PlayAppStart playAppStart = this.waitForEvent(this.startEvent);
        if (!playAppStart.isRunning()) {
            throw new GradleException("Unable to start Play application.", (Throwable)playAppStart.getException());
        }
        this.playAppAddress = playAppStart.getAddress();
    }

    private <T> T waitForEvent(BlockingQueue<T> queue) {
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

