/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.javascript;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.playframework.tools.internal.Compiler;
import org.gradle.playframework.tools.internal.javascript.JavaScriptCompileDestinationCalculator;
import org.gradle.playframework.tools.internal.javascript.JavaScriptCompileSpec;
import org.gradle.playframework.tools.internal.reflection.DirectInstantiator;
import org.gradle.playframework.tools.internal.reflection.JavaMethod;
import org.gradle.playframework.tools.internal.reflection.JavaReflectionUtil;
import org.gradle.playframework.tools.internal.reflection.PropertyAccessor;
import org.gradle.plugins.javascript.base.SourceTransformationException;

public class GoogleClosureCompiler
implements Compiler<JavaScriptCompileSpec>,
Serializable {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("com.google.javascript");
    private static final String DEFAULT_GOOGLE_CLOSURE_VERSION = "v20141215";
    private Class<?> sourceFileClass;
    private Class<?> compilerOptionsClass;
    private Class<Enum> compilationLevelClass;
    private Class<Object> compilerClass;

    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    public static Object getDependencyNotation() {
        return "com.google.javascript:closure-compiler:v20141215";
    }

    @Override
    public WorkResult execute(JavaScriptCompileSpec spec) {
        JavaScriptCompileDestinationCalculator destinationCalculator = new JavaScriptCompileDestinationCalculator(spec.getDestinationDir());
        ArrayList<String> allErrors = new ArrayList<String>();
        for (RelativeFile sourceFile : spec.getSources()) {
            allErrors.addAll(this.compile(sourceFile, spec, destinationCalculator));
        }
        if (allErrors.isEmpty()) {
            return WorkResults.didWork((boolean)true);
        }
        throw new SourceTransformationException(String.format("Minification failed with the following errors:\n\t%s", String.join((CharSequence)"\n\t", allErrors)), null);
    }

    List<String> compile(RelativeFile javascriptFile, JavaScriptCompileSpec spec, JavaScriptCompileDestinationCalculator destinationCalculator) {
        ArrayList<String> errors = new ArrayList<String>();
        this.loadCompilerClasses(this.getClass().getClassLoader());
        JavaMethod<?, Object> fromCodeJavaMethod = JavaReflectionUtil.staticMethod(this.sourceFileClass, Object.class, "fromCode", String.class, String.class);
        Object extern = fromCodeJavaMethod.invokeStatic("/dev/null", "");
        JavaMethod<?, Object> fromFileJavaMethod = JavaReflectionUtil.staticMethod(this.sourceFileClass, Object.class, "fromFile", File.class);
        Object sourceFile = fromFileJavaMethod.invokeStatic(javascriptFile.getFile());
        Object compilerOptions = DirectInstantiator.INSTANCE.newInstance(this.compilerOptionsClass, new Object[0]);
        Enum simpleLevel = Enum.valueOf(this.compilationLevelClass, "SIMPLE_OPTIMIZATIONS");
        JavaMethod<Class<Enum>, Void> setOptionsForCompilationLevelMethod = JavaReflectionUtil.method(this.compilationLevelClass, Void.class, "setOptionsForCompilationLevel", new Class[]{this.compilerOptionsClass});
        setOptionsForCompilationLevelMethod.invoke((Class<Enum>)((Object)simpleLevel), compilerOptions);
        Object compiler = DirectInstantiator.INSTANCE.newInstance(this.compilerClass, this.getDummyPrintStream());
        JavaMethod<Class<Object>, Object> compileMethod = JavaReflectionUtil.method(this.compilerClass, Object.class, "compile", new Class[]{this.sourceFileClass, this.sourceFileClass, this.compilerOptionsClass});
        Object result = compileMethod.invoke((Class<Object>)compiler, extern, sourceFile, compilerOptions);
        PropertyAccessor<Object, Object[]> jsErrorsField = JavaReflectionUtil.readableField(result, Object[].class, "errors");
        Object[] jsErrors = jsErrorsField.getValue(result);
        if (jsErrors.length == 0) {
            JavaMethod<Class<Object>, String> toSourceMethod = JavaReflectionUtil.method(this.compilerClass, String.class, "toSource", new Class[0]);
            String compiledSource = toSourceMethod.invoke((Class<Object>)compiler, new Object[0]);
            try {
                Files.write(destinationCalculator.transform(javascriptFile).toPath(), compiledSource.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        } else {
            for (Object error : jsErrors) {
                errors.add(error.toString());
            }
        }
        return errors;
    }

    private void loadCompilerClasses(ClassLoader cl) {
        try {
            Class<?> clazz;
            if (this.sourceFileClass == null) {
                this.sourceFileClass = cl.loadClass("com.google.javascript.jscomp.SourceFile");
            }
            if (this.compilerOptionsClass == null) {
                this.compilerOptionsClass = cl.loadClass("com.google.javascript.jscomp.CompilerOptions");
            }
            if (this.compilationLevelClass == null) {
                clazz = cl.loadClass("com.google.javascript.jscomp.CompilationLevel");
                this.compilationLevelClass = clazz;
            }
            if (this.compilerClass == null) {
                clazz = cl.loadClass("com.google.javascript.jscomp.Compiler");
                this.compilerClass = clazz;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private PrintStream getDummyPrintStream() {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        return new PrintStream(os);
    }
}

