/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tasks.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.playframework.tools.internal.Compiler;
import org.gradle.playframework.tools.internal.twirl.TwirlCompileSpec;

public class TwirlCompileRunnable
implements Runnable {
    private final TwirlCompileSpec twirlCompileSpec;
    private final Compiler<TwirlCompileSpec> compiler;

    @Inject
    public TwirlCompileRunnable(TwirlCompileSpec twirlCompileSpec, Compiler<TwirlCompileSpec> compiler) {
        this.twirlCompileSpec = twirlCompileSpec;
        this.compiler = compiler;
    }

    @Override
    public void run() {
        Path destinationPath = this.twirlCompileSpec.getDestinationDir().toPath();
        this.deleteOutputs(destinationPath);
        this.compiler.execute(this.twirlCompileSpec);
    }

    private void deleteOutputs(Path pathToBeDeleted) {
        try {
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).map(path -> path.toFile()).forEach(file -> file.delete());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

