/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tasks;

import java.io.File;
import java.net.InetSocketAddress;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.tools.internal.run.DefaultPlayRunSpec;
import org.gradle.playframework.tools.internal.run.PlayApplicationDeploymentHandle;
import org.gradle.playframework.tools.internal.run.PlayApplicationRunner;
import org.gradle.playframework.tools.internal.run.PlayApplicationRunnerFactory;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayRun
extends DefaultTask {
    public static final int DEFAULT_HTTP_PORT = 9000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayRun.class);
    private final BaseForkOptions forkOptions;
    private final Property<Integer> httpPort;
    private final DirectoryProperty workingDir;
    private final RegularFileProperty applicationJar;
    private final RegularFileProperty assetsJar;
    private final ConfigurableFileCollection assetsDirs;
    private final ConfigurableFileCollection runtimeClasspath;
    private final ConfigurableFileCollection changingClasspath;
    private final Property<PlayPlatform> platform;

    public PlayRun() {
        ObjectFactory objects = this.getProject().getObjects();
        this.httpPort = objects.property(Integer.class).value((Object)9000);
        this.workingDir = objects.directoryProperty();
        this.applicationJar = objects.fileProperty();
        this.assetsJar = objects.fileProperty();
        this.assetsDirs = this.getProject().files(new Object[0]);
        this.runtimeClasspath = this.getProject().files(new Object[0]);
        this.changingClasspath = this.getProject().files(new Object[0]);
        this.platform = objects.property(PlayPlatform.class);
        this.forkOptions = new BaseForkOptions();
    }

    @TaskAction
    public void run() {
        String deploymentId = this.getPath();
        DeploymentRegistry deploymentRegistry = this.getDeploymentRegistry();
        PlayApplicationDeploymentHandle deploymentHandle = (PlayApplicationDeploymentHandle)deploymentRegistry.get(deploymentId, PlayApplicationDeploymentHandle.class);
        if (deploymentHandle == null) {
            DefaultPlayRunSpec spec = new DefaultPlayRunSpec((Iterable<File>)this.runtimeClasspath, (Iterable<File>)this.changingClasspath, (File)this.applicationJar.getAsFile().get(), (File)this.assetsJar.getAsFile().get(), (Iterable<File>)this.assetsDirs, ((Directory)this.workingDir.get()).getAsFile(), this.getForkOptions(), (Integer)this.getHttpPort().get());
            PlayApplicationRunner playApplicationRunner = PlayApplicationRunnerFactory.create((PlayPlatform)this.platform.get(), this.getWorkerProcessFactory(), this.getClasspathFingerprinter());
            deploymentHandle = (PlayApplicationDeploymentHandle)deploymentRegistry.start(deploymentId, DeploymentRegistry.ChangeBehavior.BLOCK, PlayApplicationDeploymentHandle.class, new Object[]{spec, playApplicationRunner});
            InetSocketAddress playAppAddress = deploymentHandle.getPlayAppAddress();
            String playUrl = "http://localhost:" + playAppAddress.getPort() + "/";
            LOGGER.warn("Running Play App ({}) at {}", (Object)this.getPath(), (Object)playUrl);
        }
    }

    @Nested
    public BaseForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Internal
    public Property<Integer> getHttpPort() {
        return this.httpPort;
    }

    @Internal
    public DirectoryProperty getWorkingDir() {
        return this.workingDir;
    }

    @Classpath
    public RegularFileProperty getApplicationJar() {
        return this.applicationJar;
    }

    @Classpath
    public RegularFileProperty getAssetsJar() {
        return this.assetsJar;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getAssetsDirs() {
        return this.assetsDirs;
    }

    @Classpath
    public ConfigurableFileCollection getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    @Classpath
    public ConfigurableFileCollection getChangingClasspath() {
        return this.changingClasspath;
    }

    @Nested
    public Property<PlayPlatform> getPlatform() {
        return this.platform;
    }

    @Inject
    public DeploymentRegistry getDeploymentRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public WorkerProcessFactory getWorkerProcessFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public ClasspathFingerprinter getClasspathFingerprinter() {
        throw new UnsupportedOperationException();
    }
}

