/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins.internal;

import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public final class PlayPluginHelper {
    private PlayPluginHelper() {
    }

    public static SourceSet getMainJavaSourceSet(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        return (SourceSet)javaConvention.getSourceSets().getByName("main");
    }

    public static SourceSet getTestJavaSourceSet(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        return (SourceSet)javaConvention.getSourceSets().getByName("test");
    }

    public static SourceDirectorySet getMainScalaSourceDirectorySet(Project project) {
        return PlayPluginHelper.getScalaSourceDirectorySet(PlayPluginHelper.getMainJavaSourceSet(project));
    }

    public static SourceDirectorySet getTestScalaSourceDirectorySet(Project project) {
        return PlayPluginHelper.getScalaSourceDirectorySet(PlayPluginHelper.getTestJavaSourceSet(project));
    }

    private static SourceDirectorySet getScalaSourceDirectorySet(SourceSet sourceSet) {
        return (SourceDirectorySet)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getScala", null);
    }

    public static <T> T createCustomSourceSet(Project project, Class<? extends T> t, String name) {
        SourceSet mainSourceSet = PlayPluginHelper.getMainJavaSourceSet(project);
        Object customSourceSet = project.getObjects().newInstance(t, new Object[]{name, ((DefaultSourceSet)mainSourceSet).getDisplayName(), project.getObjects()});
        new DslObject((Object)mainSourceSet).getConvention().getPlugins().put(name, customSourceSet);
        return (T)customSourceSet;
    }
}

