/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.progress.BuildOperationCategory;

public class GroupingProgressLogEventGenerator
extends BatchOutputEventListener {
    static final String EOL = SystemProperties.getInstance().getLineSeparator();
    private final OutputEventListener listener;
    private final Map<Object, Object> buildOpIdHierarchy = new HashMap<Object, Object>();
    private final Map<Object, OperationGroup> operationsInProgress = new LinkedHashMap<Object, OperationGroup>();
    private final Map<OperationIdentifier, Object> progressToBuildOpIdMap = new HashMap<OperationIdentifier, Object>();
    private Object lastRenderedBuildOpId;
    private boolean needsHeader;

    public GroupingProgressLogEventGenerator(OutputEventListener listener) {
        this.listener = listener;
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.onStart((ProgressStartEvent)event);
        } else if (event instanceof RenderableOutputEvent) {
            this.handleOutput((RenderableOutputEvent)event);
        } else if (event instanceof ProgressCompleteEvent) {
            this.onComplete((ProgressCompleteEvent)event);
        } else if (event instanceof EndOutputEvent) {
            this.onEnd((EndOutputEvent)event);
        } else if (!(event instanceof ProgressEvent)) {
            this.listener.onOutput(event);
        }
    }

    private void onStart(ProgressStartEvent startEvent) {
        Object buildOpId = startEvent.getBuildOperationId();
        if (buildOpId != null) {
            this.buildOpIdHierarchy.put(buildOpId, startEvent.getParentBuildOperationId());
            this.progressToBuildOpIdMap.put(startEvent.getProgressOperationId(), buildOpId);
            if (this.isGroupedOperation(startEvent.getBuildOperationCategory())) {
                String header = startEvent.getLoggingHeader() != null ? startEvent.getLoggingHeader() : startEvent.getDescription();
                this.operationsInProgress.put(buildOpId, new OperationGroup(startEvent.getCategory(), header, startEvent.getTimestamp(), startEvent.getBuildOperationId()));
            }
        }
    }

    private boolean isGroupedOperation(BuildOperationCategory buildOperationCategory) {
        return buildOperationCategory == BuildOperationCategory.TASK || buildOperationCategory == BuildOperationCategory.CONFIGURE_PROJECT;
    }

    private void handleOutput(RenderableOutputEvent event) {
        Object operationId = this.getOperationId(event.getBuildOperationId());
        if (operationId != null) {
            this.operationsInProgress.get(operationId).bufferOutput(event);
        } else {
            this.onUngroupedOutput(event);
        }
    }

    private void onComplete(ProgressCompleteEvent completeEvent) {
        Object buildOpId = this.progressToBuildOpIdMap.remove(completeEvent.getProgressOperationId());
        this.buildOpIdHierarchy.remove(buildOpId);
        OperationGroup group = this.operationsInProgress.remove(buildOpId);
        if (group != null) {
            group.flushOutput();
        }
    }

    private void onEnd(EndOutputEvent event) {
        for (OperationGroup group : this.operationsInProgress.values()) {
            group.flushOutput();
        }
        this.listener.onOutput(event);
        this.buildOpIdHierarchy.clear();
        this.operationsInProgress.clear();
        this.progressToBuildOpIdMap.clear();
    }

    private void onUngroupedOutput(RenderableOutputEvent event) {
        this.needsHeader = true;
        this.listener.onOutput(event);
    }

    private Object getOperationId(@Nullable Object buildOpId) {
        Object current = buildOpId;
        while (current != null) {
            if (this.operationsInProgress.containsKey(current)) {
                return current;
            }
            current = this.buildOpIdHierarchy.get(current);
        }
        return null;
    }

    private class OperationGroup {
        private final Object buildOpIdentifier;
        private final String category;
        private final String loggingHeader;
        private final long startTime;
        private List<RenderableOutputEvent> bufferedLogs = new ArrayList<RenderableOutputEvent>();

        private OperationGroup(@Nullable String category, String loggingHeader, long startTime, Object buildOpIdentifier) {
            this.category = category;
            this.loggingHeader = loggingHeader;
            this.startTime = startTime;
            this.buildOpIdentifier = buildOpIdentifier;
        }

        private LogEvent spacerLine() {
            return new LogEvent(this.startTime, this.category, null, "", null);
        }

        StyledTextOutputEvent header(String message) {
            ArrayList spans = Lists.newArrayList((Object[])new StyledTextOutputEvent.Span[]{new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, "> " + message), new StyledTextOutputEvent.Span(EOL)});
            return new StyledTextOutputEvent(this.startTime, this.category, null, this.buildOpIdentifier, spans);
        }

        void bufferOutput(RenderableOutputEvent output) {
            this.bufferedLogs.add(output);
        }

        void flushOutput() {
            if (!this.bufferedLogs.isEmpty()) {
                if (GroupingProgressLogEventGenerator.this.needsHeader) {
                    GroupingProgressLogEventGenerator.this.listener.onOutput(this.spacerLine());
                    GroupingProgressLogEventGenerator.this.needsHeader = false;
                }
                GroupingProgressLogEventGenerator.this.listener.onOutput(this.header(this.loggingHeader));
                for (RenderableOutputEvent renderableEvent : this.bufferedLogs) {
                    GroupingProgressLogEventGenerator.this.listener.onOutput(renderableEvent);
                }
                if (!this.buildOpIdentifier.equals(GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId)) {
                    GroupingProgressLogEventGenerator.this.listener.onOutput(this.spacerLine());
                }
                GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId = this.buildOpIdentifier;
            }
        }
    }
}

