/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.progress.BuildOperationCategory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressStartEventSerializer
implements Serializer<ProgressStartEvent> {
    private final Serializer<BuildOperationCategory> buildOperationCategorySerializer;

    public ProgressStartEventSerializer(Serializer<BuildOperationCategory> buildOperationCategorySerializer) {
        this.buildOperationCategorySerializer = buildOperationCategorySerializer;
    }

    public void write(Encoder encoder, ProgressStartEvent event) throws Exception {
        encoder.writeSmallLong(event.getProgressOperationId().getId());
        if (event.getParentProgressOperationId() == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeSmallLong(event.getParentProgressOperationId().getId());
        }
        encoder.writeLong(event.getTimestamp());
        encoder.writeString((CharSequence)event.getCategory());
        encoder.writeString((CharSequence)event.getDescription());
        encoder.writeNullableString((CharSequence)event.getShortDescription());
        encoder.writeNullableString((CharSequence)event.getLoggingHeader());
        encoder.writeString((CharSequence)event.getStatus());
        if (event.getBuildOperationId() == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeSmallLong(((OperationIdentifier)event.getBuildOperationId()).getId());
        }
        if (event.getParentBuildOperationId() == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeSmallLong(((OperationIdentifier)event.getParentBuildOperationId()).getId());
        }
        this.buildOperationCategorySerializer.write(encoder, (Object)event.getBuildOperationCategory());
    }

    public ProgressStartEvent read(Decoder decoder) throws Exception {
        OperationIdentifier progressOperationId = new OperationIdentifier(decoder.readSmallLong());
        OperationIdentifier parentProgressOperationId = decoder.readBoolean() ? new OperationIdentifier(decoder.readSmallLong()) : null;
        long timestamp = decoder.readLong();
        String category = decoder.readString();
        String description = decoder.readString();
        String shortDescription = decoder.readNullableString();
        String loggingHeader = decoder.readNullableString();
        String status = decoder.readString();
        OperationIdentifier buildOperationId = decoder.readBoolean() ? new OperationIdentifier(decoder.readSmallLong()) : null;
        OperationIdentifier parentBuildOperationId = decoder.readBoolean() ? new OperationIdentifier(decoder.readSmallLong()) : null;
        BuildOperationCategory buildOperationCategory = (BuildOperationCategory)this.buildOperationCategorySerializer.read(decoder);
        return new ProgressStartEvent(progressOperationId, parentProgressOperationId, timestamp, category, description, shortDescription, loggingHeader, status, buildOperationId, parentBuildOperationId, buildOperationCategory);
    }
}

