/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.services;

import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineConverter;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.logging.LoggingCommandLineConverter;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.config.LoggingSystemAdapter;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.progress.DefaultProgressLoggerFactory;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.services.DefaultLoggingManagerFactory;
import org.gradle.internal.logging.services.DefaultStyledTextOutputFactory;
import org.gradle.internal.logging.services.ProgressLoggingBridge;
import org.gradle.internal.logging.services.TextStreamOutputEventListener;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.logging.slf4j.Slf4jLoggingConfigurer;
import org.gradle.internal.logging.source.DefaultStdErrLoggingSystem;
import org.gradle.internal.logging.source.DefaultStdOutLoggingSystem;
import org.gradle.internal.logging.source.JavaUtilLoggingSystem;
import org.gradle.internal.logging.source.NoOpLoggingSystem;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.logging.DeprecatedStyledTextOutputFactory;
import org.gradle.logging.StyledTextOutputFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggingServiceRegistry
extends DefaultServiceRegistry {
    private TextStreamOutputEventListener stdoutListener;

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        CommandLineLogging loggingServices = new CommandLineLogging();
        LoggingManagerInternal rootLoggingManager = ((DefaultLoggingManagerFactory)loggingServices.get(DefaultLoggingManagerFactory.class)).getRoot();
        rootLoggingManager.captureSystemSources();
        rootLoggingManager.attachSystemOutAndErr();
        return loggingServices;
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new CommandLineLogging();
    }

    public static LoggingServiceRegistry newNestedLogging() {
        return new NestedLogging();
    }

    protected CommandLineConverter<LoggingConfiguration> createCommandLineConverter() {
        return new LoggingCommandLineConverter();
    }

    protected TimeProvider createTimeProvider() {
        return new TrueTimeProvider();
    }

    protected org.gradle.internal.logging.text.StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.getStdoutListener(), (TimeProvider)this.get(TimeProvider.class));
    }

    protected StyledTextOutputFactory createDeprectatedStyledTextOutputFactory(org.gradle.internal.logging.text.StyledTextOutputFactory delegate) {
        return new DeprecatedStyledTextOutputFactory(delegate);
    }

    protected TextStreamOutputEventListener getStdoutListener() {
        if (this.stdoutListener == null) {
            this.stdoutListener = new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class));
        }
        return this.stdoutListener;
    }

    protected ProgressLoggerFactory createProgressLoggerFactory() {
        return new DefaultProgressLoggerFactory(new ProgressLoggingBridge((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
    }

    protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
        OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
        DefaultStdOutLoggingSystem stdout = new DefaultStdOutLoggingSystem(this.getStdoutListener(), (TimeProvider)this.get(TimeProvider.class));
        DefaultStdErrLoggingSystem stderr = new DefaultStdErrLoggingSystem(new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
        return new DefaultLoggingManagerFactory(renderer, new LoggingSystemAdapter(new Slf4jLoggingConfigurer(renderer)), new JavaUtilLoggingSystem(), stdout, stderr);
    }

    protected OutputEventRenderer createOutputEventRenderer() {
        return new OutputEventRenderer();
    }

    private static class NestedLogging
    extends LoggingServiceRegistry {
        private NestedLogging() {
        }

        protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
            OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
            return new DefaultLoggingManagerFactory(renderer, new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem());
        }
    }

    private static class CommandLineLogging
    extends LoggingServiceRegistry {
        private CommandLineLogging() {
        }
    }
}

