/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.util.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBufferingOutputStream
extends OutputStream {
    private boolean hasBeenClosed;
    private final byte[] lineSeparator;
    private final int bufferIncrement;
    private byte[] buf;
    private int count;
    private final Output output;

    public LineBufferingOutputStream(Action<String> action) {
        this(action, false, 2048);
    }

    public LineBufferingOutputStream(Action<String> action, boolean includeEOL) {
        this(action, includeEOL, 2048);
    }

    public LineBufferingOutputStream(Action<String> action, boolean includeEOL, int bufferLength) {
        this(new StringOutput(includeEOL, action), bufferLength);
    }

    private LineBufferingOutputStream(Output output, int bufferLength) {
        this.output = output;
        this.bufferIncrement = bufferLength;
        this.buf = new byte[bufferLength];
        this.count = 0;
        this.lineSeparator = SystemProperties.getLineSeparator().getBytes();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.hasBeenClosed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (this.count == this.buf.length) {
            int newBufLength = this.buf.length + this.bufferIncrement;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
        if (this.endsWithLineSeparator()) {
            this.flush();
        }
    }

    private boolean endsWithLineSeparator() {
        if (this.count < this.lineSeparator.length) {
            return false;
        }
        for (int i = 0; i < this.lineSeparator.length; ++i) {
            if (this.buf[this.count - this.lineSeparator.length + i] == this.lineSeparator[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void flush() {
        if (this.count != 0) {
            int length = this.count;
            if (this.endsWithLineSeparator()) {
                length -= this.lineSeparator.length;
            }
            this.output.write(this.buf, length, this.count);
        }
        this.reset();
    }

    private void reset() {
        if (this.buf.length > this.bufferIncrement) {
            this.buf = new byte[this.bufferIncrement];
        }
        this.count = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringOutput
    implements Output {
        private final boolean includeEOL;
        private final Action<String> action;

        public StringOutput(boolean includeEOL, Action<String> action) {
            this.includeEOL = includeEOL;
            this.action = action;
        }

        @Override
        public void write(byte[] buffer, int textLength, int lineLength) {
            if (this.includeEOL) {
                this.action.execute(new String(buffer, 0, lineLength));
            } else {
                this.action.execute(new String(buffer, 0, textLength));
            }
        }
    }

    private static interface Output {
        public void write(byte[] var1, int var2, int var3);
    }
}

