/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.gradle.util.GFileUtils;
import org.gradle.util.OperatingSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jvm {
    private final OperatingSystem os;

    public static Jvm current() {
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.toLowerCase().startsWith("apple inc.")) {
            return new AppleJvm(OperatingSystem.current());
        }
        return new Jvm(OperatingSystem.current());
    }

    Jvm(OperatingSystem os) {
        this.os = os;
    }

    public String toString() {
        return String.format("%s (%s %s)", System.getProperty("java.version"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"));
    }

    public File getJavaExecutable() {
        return new File(JavaEnvUtils.getJdkExecutable((String)"java"));
    }

    public File getJavadocExecutable() {
        return new File(JavaEnvUtils.getJdkExecutable((String)"javadoc"));
    }

    public File getJpsExecutable() {
        return new File(JavaEnvUtils.getJdkExecutable((String)"jps"));
    }

    public boolean isJava5Compatible() {
        return System.getProperty("java.version").startsWith("1.5") || this.isJava6Compatible();
    }

    public boolean isJava6Compatible() {
        return System.getProperty("java.version").startsWith("1.6");
    }

    public File getJavaHome() {
        File toolsJar = this.getToolsJar();
        return toolsJar == null ? this.getDefaultJavaHome() : toolsJar.getParentFile().getParentFile();
    }

    private File getDefaultJavaHome() {
        return GFileUtils.canonicalise(new File(System.getProperty("java.home")));
    }

    public File getToolsJar() {
        File javaHome = this.getDefaultJavaHome();
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar;
        }
        if (javaHome.getName().equalsIgnoreCase("jre") && (toolsJar = new File(javaHome = javaHome.getParentFile(), "lib/tools.jar")).exists()) {
            return toolsJar;
        }
        if (javaHome.getName().matches("jre\\d+") && this.os.isWindows() && (toolsJar = new File(javaHome = new File(javaHome.getParentFile(), String.format("jdk%s", System.getProperty("java.version"))), "lib/tools.jar")).exists()) {
            return toolsJar;
        }
        return null;
    }

    public Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> envVars) {
        return envVars;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppleJvm
    extends Jvm {
        AppleJvm(OperatingSystem os) {
            super(os);
        }

        @Override
        public Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> envVars) {
            HashMap vars = new HashMap();
            for (Map.Entry<String, ?> entry : envVars.entrySet()) {
                if (entry.getKey().matches("APP_NAME_\\d+") || entry.getKey().matches("JAVA_MAIN_CLASS_\\d+")) continue;
                vars.put(entry.getKey(), entry.getValue());
            }
            return vars;
        }
    }
}

