/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends ClassLoader {
    private static final Set<ClassLoader> SYSTEM_CLASS_LOADERS = new HashSet<ClassLoader>();
    private static final ClassLoader EXT_CLASS_LOADER;
    private static final Set<Package> SYSTEM_PACKAGES;
    private final Set<String> packageNames = new HashSet<String>();
    private final Set<String> packagePrefixes = new HashSet<String>();
    private final Set<String> resourcePrefixes = new HashSet<String>();
    private final Set<String> classNames = new HashSet<String>();

    public FilteringClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl;
        try {
            cl = super.loadClass(name, false);
        }
        catch (NoClassDefFoundError e) {
            if (this.classAllowed(name)) {
                throw e;
            }
            throw new ClassNotFoundException(String.format("%s not found.", name));
        }
        if (!this.allowed(cl)) {
            throw new ClassNotFoundException(String.format("%s not found.", cl.getName()));
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    @Override
    protected Package getPackage(String name) {
        Package p = super.getPackage(name);
        if (p == null || !this.allowed(p)) {
            return null;
        }
        return p;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Package p : super.getPackages()) {
            if (!this.allowed(p)) continue;
            packages.add(p);
        }
        return packages.toArray(new Package[packages.size()]);
    }

    @Override
    public URL getResource(String name) {
        if (this.allowed(name)) {
            return super.getResource(name);
        }
        return EXT_CLASS_LOADER.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.allowed(name)) {
            return super.getResources(name);
        }
        return EXT_CLASS_LOADER.getResources(name);
    }

    private boolean allowed(String resourceName) {
        for (String resourcePrefix : this.resourcePrefixes) {
            if (!resourceName.startsWith(resourcePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(Package p) {
        if (SYSTEM_PACKAGES.contains(p)) {
            return true;
        }
        for (String packageName : this.packageNames) {
            if (!p.getName().equals(packageName)) continue;
            return true;
        }
        for (String packagePrefix : this.packagePrefixes) {
            if (!p.getName().startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(final Class<?> cl) {
        boolean systemClass = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return cl.getClassLoader() == null || SYSTEM_CLASS_LOADERS.contains(cl.getClassLoader());
            }
        });
        return systemClass || this.classAllowed(cl.getName());
    }

    private boolean classAllowed(String className) {
        if (this.classNames.contains(className)) {
            return true;
        }
        for (String packagePrefix : this.packagePrefixes) {
            if (!className.startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    public void allowPackage(String packageName) {
        this.packageNames.add(packageName);
        this.packagePrefixes.add(packageName + ".");
        this.resourcePrefixes.add(packageName.replace('.', '/') + '/');
    }

    public void allowClass(Class<?> aClass) {
        this.classNames.add(aClass.getName());
    }

    static {
        SYSTEM_PACKAGES = new HashSet<Package>();
        for (ClassLoader cl = EXT_CLASS_LOADER = ClassLoader.getSystemClassLoader().getParent(); cl != null; cl = cl.getParent()) {
            SYSTEM_CLASS_LOADERS.add(cl);
        }
        JavaMethod<ClassLoader, Package[]> method = new JavaMethod<ClassLoader, Package[]>(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
        SYSTEM_PACKAGES.addAll(Arrays.asList(method.invoke(EXT_CLASS_LOADER, new Object[0])));
    }
}

