/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecationLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationLogger.class);
    private static final Set<String> METHODS = new CopyOnWriteArraySet<String>();

    public static void nagUser(String methodName, String replacement) {
        if (METHODS.add(methodName)) {
            LOGGER.warn(String.format("The %s method is deprecated and will be removed in the next version of Gradle. You should use the %s method instead.", methodName, replacement));
        }
    }

    public static void nagUser(String methodName) {
        if (METHODS.add(methodName)) {
            LOGGER.warn(String.format("The %s method is deprecated and will be removed in the next version of Gradle.", methodName));
        }
    }
}

