/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.Map;
import org.gradle.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureUtil {
    public static <T> T configure(Closure configureClosure, T delegate) {
        return ConfigureUtil.configure(configureClosure, delegate, 1);
    }

    public static <T> T configureByMap(Map<String, ?> properties, T delegate) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            try {
                ReflectionUtil.setProperty(delegate, entry.getKey(), entry.getValue());
            }
            catch (MissingPropertyException e) {
                try {
                    ReflectionUtil.invoke(delegate, entry.getKey(), entry.getValue());
                }
                catch (MissingMethodException mme) {
                    throw e;
                }
            }
        }
        return delegate;
    }

    private static <T> T configure(Closure configureClosure, T delegate, int resolveStrategy) {
        if (configureClosure == null) {
            return delegate;
        }
        Closure copy = (Closure)configureClosure.clone();
        copy.setResolveStrategy(resolveStrategy);
        copy.setDelegate(delegate);
        if (copy.getMaximumNumberOfParameters() == 0) {
            copy.call();
        } else {
            copy.call(delegate);
        }
        return delegate;
    }
}

