/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures;

import java.io.File;
import java.io.IOException;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.invocation.DefaultGradle;
import org.gradle.testfixtures.internal.GlobalTestServices;
import org.gradle.testfixtures.internal.TestTopLevelBuildServiceRegistry;
import org.gradle.util.GFileUtils;

public class ProjectBuilder {
    private static final GlobalTestServices GLOBAL_SERVICES = new GlobalTestServices();
    private File projectDir;

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    public ProjectBuilder withProjectDir(File dir) {
        this.projectDir = GFileUtils.canonicalise(dir);
        return this;
    }

    public Project build() {
        if (this.projectDir == null) {
            try {
                this.projectDir = GFileUtils.canonicalise(File.createTempFile("gradle", "projectDir"));
                this.projectDir.delete();
                this.projectDir.mkdir();
                this.projectDir.deleteOnExit();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        File homeDir = new File(this.projectDir, "gradleHome");
        StartParameter startParameter = new StartParameter();
        startParameter.setGradleUserHomeDir(new File(this.projectDir, "userHome"));
        TestTopLevelBuildServiceRegistry topLevelRegistry = new TestTopLevelBuildServiceRegistry(GLOBAL_SERVICES, startParameter, homeDir);
        DefaultGradle gradle = new DefaultGradle(null, startParameter, topLevelRegistry);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, "test", this.projectDir, new DefaultProjectDescriptorRegistry());
        ProjectInternal project = topLevelRegistry.get(IProjectFactory.class).createProject(projectDescriptor, null, gradle);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        return project;
    }
}

