/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.profile.TaskProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfile {
    private Project project;
    private long beforeEvaluate;
    private long afterEvaluate;
    private ProjectState state;
    private HashMap<Task, TaskProfile> tasks = new HashMap();

    public ProjectProfile(Project project) {
        this.project = project;
    }

    public TaskProfile getTaskProfile(Task task) {
        TaskProfile result = this.tasks.get(task);
        if (result == null) {
            result = new TaskProfile(task);
            this.tasks.put(task, result);
        }
        return result;
    }

    public List<TaskProfile> getTaskProfiles() {
        return new ArrayList<TaskProfile>(this.tasks.values());
    }

    public String getPath() {
        return this.project.getPath();
    }

    public void setBeforeEvaluate(long beforeEvaluate) {
        this.beforeEvaluate = beforeEvaluate;
    }

    public void setAfterEvaluate(long afterEvaluate) {
        this.afterEvaluate = afterEvaluate;
    }

    public ProjectState getState() {
        return this.state;
    }

    public void setState(ProjectState state) {
        this.state = state;
    }

    public long getElapsedEvaluation() {
        return this.afterEvaluate - this.beforeEvaluate;
    }

    public long getElapsedTaskExecution() {
        long result = 0L;
        for (TaskProfile taskProfile : this.tasks.values()) {
            result += taskProfile.getElapsedExecution();
        }
        return result;
    }
}

