/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.shutdown;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.UncheckedIOException;

public class ShutdownHookActionRegister {
    private static final ShutdownHookActionRegister INSTANCE = new ShutdownHookActionRegister();
    private final List<Runnable> shutdownHookActions = new CopyOnWriteArrayList<Runnable>();

    private ShutdownHookActionRegister() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new GradleShutdownHook(), "gradle-shutdown-hook"));
    }

    public static void addAction(Runnable shutdownHookAction) {
        ShutdownHookActionRegister.INSTANCE.shutdownHookActions.add(shutdownHookAction);
    }

    public static void removeAction(Runnable shutdownHookAction) {
        ShutdownHookActionRegister.INSTANCE.shutdownHookActions.remove(shutdownHookAction);
    }

    public static void closeOnExit(final Closeable closeable) {
        ShutdownHookActionRegister.addAction(new Runnable(){

            public void run() {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private class GradleShutdownHook
    implements Runnable {
        private GradleShutdownHook() {
        }

        public void run() {
            for (Runnable shutdownHookAction : ShutdownHookActionRegister.this.shutdownHookActions) {
                try {
                    shutdownHookAction.run();
                }
                catch (Throwable t) {
                    System.err.println("failed to execute a shutdown action.");
                    t.printStackTrace(System.err);
                }
            }
        }
    }
}

