/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.process.internal.child.WorkerContext;
import org.gradle.util.ClassLoaderObjectInputStream;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemApplicationClassLoaderWorker
implements Callable<Void> {
    private final byte[] serializedWorker;
    private final Collection<File> applicationClassPath;

    public SystemApplicationClassLoaderWorker(Collection<File> applicationClassPath, byte[] serializedWorker) {
        this.applicationClassPath = applicationClassPath;
        this.serializedWorker = serializedWorker;
    }

    @Override
    public Void call() throws Exception {
        final ClassLoader applicationClassLoader = ClassLoader.getSystemClassLoader();
        ClasspathUtil.addUrl((URLClassLoader)applicationClassLoader, GFileUtils.toURLs(this.applicationClassPath));
        System.setProperty("java.class.path", GUtil.join(this.applicationClassPath, File.pathSeparator));
        ClassLoaderObjectInputStream instr = new ClassLoaderObjectInputStream(new ByteArrayInputStream(this.serializedWorker), this.getClass().getClassLoader());
        Action action = (Action)instr.readObject();
        action.execute(new WorkerContext(){

            public ClassLoader getApplicationClassLoader() {
                return applicationClassLoader;
            }
        });
        return null;
    }
}

