/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.process.internal.child.WorkerContext;
import org.gradle.util.ObservableUrlClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedApplicationClassLoaderWorker
implements Callable<Void>,
Serializable {
    private final Action<WorkerContext> worker;
    private final Collection<URL> applicationClassPath;

    public IsolatedApplicationClassLoaderWorker(Collection<URL> applicationClassPath, Action<WorkerContext> worker) {
        this.applicationClassPath = applicationClassPath;
        this.worker = worker;
    }

    @Override
    public Void call() throws Exception {
        final ObservableUrlClassLoader applicationClassLoader = this.createApplicationClassLoader();
        WorkerContext context = new WorkerContext(){

            public ClassLoader getApplicationClassLoader() {
                return applicationClassLoader;
            }
        };
        this.worker.execute(context);
        return null;
    }

    private ObservableUrlClassLoader createApplicationClassLoader() {
        return new ObservableUrlClassLoader(ClassLoader.getSystemClassLoader().getParent(), this.applicationClassPath);
    }
}

