/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.process.internal.child.WorkerContext;
import org.gradle.util.ClassLoaderObjectInputStream;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.GUtil;
import org.gradle.util.MultiParentClassLoader;
import org.gradle.util.ObservableUrlClassLoader;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationClassLoaderWorker
implements Action<WorkerContext>,
Serializable {
    private final LogLevel logLevel;
    private final Collection<String> sharedPackages;
    private final Collection<URL> implementationClassPath;
    private final byte[] serializedWorkerAction;

    protected ImplementationClassLoaderWorker(LogLevel logLevel, Collection<String> sharedPackages, Collection<URL> implementationClassPath, Action<WorkerContext> workerAction) {
        this.logLevel = logLevel;
        this.sharedPackages = sharedPackages;
        this.implementationClassPath = implementationClassPath;
        this.serializedWorkerAction = GUtil.serialize(workerAction);
    }

    @Override
    public void execute(WorkerContext workerContext) {
        Action action;
        LoggingManagerInternal loggingManager = this.createLoggingManager();
        loggingManager.setLevel(this.logLevel).start();
        FilteringClassLoader filteredWorkerClassLoader = new FilteringClassLoader(this.getClass().getClassLoader());
        filteredWorkerClassLoader.allowPackage("org.slf4j");
        filteredWorkerClassLoader.allowClass(Action.class);
        filteredWorkerClassLoader.allowClass(WorkerContext.class);
        ClassLoader applicationClassLoader = workerContext.getApplicationClassLoader();
        FilteringClassLoader filteredApplication = new FilteringClassLoader(applicationClassLoader);
        ObservableUrlClassLoader implementationClassLoader = this.createImplementationClassLoader(filteredWorkerClassLoader, filteredApplication);
        for (String sharedPackage : this.sharedPackages) {
            filteredApplication.allowPackage(sharedPackage);
        }
        implementationClassLoader.addURLs(this.implementationClassPath);
        try {
            ClassLoaderObjectInputStream instr = new ClassLoaderObjectInputStream(new ByteArrayInputStream(this.serializedWorkerAction), implementationClassLoader);
            action = (Action)instr.readObject();
        }
        catch (Exception e) {
            throw UncheckedException.asUncheckedException(e);
        }
        action.execute(workerContext);
    }

    LoggingManagerInternal createLoggingManager() {
        return LoggingServiceRegistry.newChildProcessLogging().newInstance(LoggingManagerInternal.class);
    }

    ObservableUrlClassLoader createImplementationClassLoader(ClassLoader system, ClassLoader application) {
        return new ObservableUrlClassLoader((ClassLoader)new MultiParentClassLoader(application, system), new URL[0]);
    }
}

